package com.elitesland.cbpl.unionpay.shoupay.domain.resp;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <strong>返回示例（映射接收biz_response字段）：</strong>
 * <pre><code class='json'>
 * {
 *   "result_code": "200",
 *   "biz_response": {
 *     "terminal_sn": "10298371039",
 *     "terminal_key": "68d499beda5f72116592f5c527465656"
 *   }
 * }
 * </code></pre>
 *
 * @author eric.hao
 * @since 2023/11/27
 */
@Data
@ApiModel("设备激活")
public class ShouPayTerminalRespVO {

    @JsonProperty("terminal_sn")
    @ApiModelProperty("终端号")
    private String terminalSn;

    @JsonProperty("terminal_key")
    @ApiModelProperty("终端密钥")
    private String terminalKey;

    @JsonProperty("merchant_sn")
    @ApiModelProperty("商户编码")
    private String merchantSn;

    @JsonProperty("merchant_name")
    @ApiModelProperty("商户名称")
    private String merchantName;

    @JsonProperty("store_sn")
    @ApiModelProperty("门店编码")
    private String storeSn;

    @JsonProperty("store_name")
    @ApiModelProperty("门店名称")
    private String storeName;

    /**
     * 数据是否可用
     */
    public boolean valid() {
        return StrUtil.isNotBlank(terminalSn) && StrUtil.isNotBlank(terminalKey);
    }
}
