/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unionpay.shoupay.config;

import com.elitesland.cbpl.unionpay.shoupay.cache.ShouPayCache;
import com.elitesland.cbpl.unionpay.shoupay.config.ShouPayProperties;
import com.elitesland.cbpl.unionpay.shoupay.data.controller.ShouPayDemo;
import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayDeviceService;
import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayVendorService;
import com.elitesland.cbpl.unionpay.shoupay.proxy.ShouPayProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ShouPayProperties.class})
@ConditionalOnProperty(prefix="cbpl.unionpay.shoupay", name={"enabled"}, havingValue="true")
public class ShouPayConfig {
    private static final Logger logger = LoggerFactory.getLogger(ShouPayConfig.class);

    @Bean
    public ShouPayCache shouPayCache(ShouPayVendorService vendorService, ShouPayDeviceService deviceService) {
        return new ShouPayCache(vendorService, deviceService);
    }

    @Bean
    public ShouPayProxy shouPayProxy(ShouPayCache shouPayCache) {
        logger.info("[PHOENIX-UNIONPAY] load shouqianba pay (ShouPay).");
        return new ShouPayProxy(shouPayCache);
    }

    @Bean
    public ShouPayDemo shouPayDemo(ShouPayProxy shouPayProxy, ShouPayDeviceService deviceService) {
        return new ShouPayDemo(shouPayProxy, deviceService);
    }
}

