/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unionpay.shoupay.data.controller;

import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayDeviceService;
import com.elitesland.cbpl.unionpay.shoupay.domain.base.ShouPayRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayCancelParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayRefundParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.param.ShouPayTradeParamVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayCancelRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayQueryRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayRefundRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayTerminalRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayTradeRespVO;
import com.elitesland.cbpl.unionpay.shoupay.proxy.ShouPayProxy;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Api(tags={"\u6536\u94b1\u5427 - \u5e38\u7528API\u793a\u4f8b"})
@ApiSupport(author="eric.hao", order=3)
@RequestMapping(value={"/demo/unionpay/shoupay"})
public class ShouPayDemo {
    private static final Logger logger = LoggerFactory.getLogger(ShouPayDemo.class);
    private final ShouPayProxy shouPayProxy;
    private final ShouPayDeviceService shouPayDeviceService;

    @ApiOperation(value="01.\u8bbe\u5907\u6fc0\u6d3b")
    @GetMapping(value={"/activate"})
    public ShouPayTerminalRespVO activate(String deviceId) {
        return this.shouPayDeviceService.activate(deviceId);
    }

    @ApiOperation(value="02.\u8bbe\u5907\u7b7e\u5230")
    @GetMapping(value={"/checkin"})
    public ShouPayTerminalRespVO checkin(String deviceId) {
        return this.shouPayDeviceService.checkin(deviceId);
    }

    @ApiOperation(value="03.\u4ed8\u6b3e")
    @PostMapping(value={"/pay"})
    public ShouPayRespVO<ShouPayTradeRespVO> pay(String deviceId, @RequestBody @Validated ShouPayTradeParamVO paramVO) {
        return this.shouPayProxy.pay(deviceId, paramVO);
    }

    @ApiOperation(value="04.\u9000\u6b3e")
    @PostMapping(value={"/refund"})
    public ShouPayRespVO<ShouPayRefundRespVO> refund(String deviceId, @RequestBody @Validated ShouPayRefundParamVO paramVO) {
        return this.shouPayProxy.refund(deviceId, paramVO);
    }

    @ApiOperation(value="05.\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public ShouPayRespVO<ShouPayQueryRespVO> query(String deviceId, @RequestBody @Validated ShouPayQueryParamVO paramVO) {
        return this.shouPayProxy.query(deviceId, paramVO);
    }

    @ApiOperation(value="06.\u81ea\u52a8\u64a4\u5355")
    @PostMapping(value={"/cancel"})
    public ShouPayRespVO<ShouPayCancelRespVO> cancel(String deviceId, @RequestBody @Validated ShouPayCancelParamVO paramVO) {
        return this.shouPayProxy.cancel(deviceId, paramVO);
    }

    @ApiOperation(value="06.\u624b\u52a8\u64a4\u5355")
    @PostMapping(value={"/revoke"})
    public ShouPayRespVO<ShouPayCancelRespVO> revoke(String deviceId, @RequestBody @Validated ShouPayCancelParamVO paramVO) {
        return this.shouPayProxy.revoke(deviceId, paramVO);
    }

    public ShouPayDemo(ShouPayProxy shouPayProxy, ShouPayDeviceService shouPayDeviceService) {
        this.shouPayProxy = shouPayProxy;
        this.shouPayDeviceService = shouPayDeviceService;
    }
}

