package com.elitesland.cbpl.unionpay.shoupay.data.service;

import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayVendorQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayVendorSaveParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayVendorDetailVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayVendorRespVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
public interface ShouPayVendorService {

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<ShouPayVendorRespVO> shouPayVendorByParam(ShouPayVendorQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    ShouPayVendorDetailVO shouPayVendorById(Long id);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(ShouPayVendorSaveParamVO saveParam);
}
