package com.elitesland.cbpl.unionpay.shoupay.domain.base;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2023/11/27
 */
@Data
@ApiModel("收钱吧接口返回数据")
public class ShouPayRespVO<T> {

    /**
     * 200：通讯成功；400：客户端错误；500:服务端错误
     */
    @JsonProperty("result_code")
    @ApiModelProperty("状态码")
    private String resultCode;

    @JsonProperty("error_code")
    @ApiModelProperty("错误码")
    private String errorCode;

    @JsonProperty("error_message")
    @ApiModelProperty("错误原因")
    private String errorMessage;

    @JsonProperty("biz_response")
    @ApiModelProperty("数据对象")
    private T data;

    /**
     * 是否成功
     */
    public boolean success() {
        return StrUtil.isNotBlank(resultCode) && resultCode.equals("200");
    }

    /**
     * 是否失败
     */
    public boolean fail() {
        return !success();
    }

    /**
     * 接口异常
     */
    public static <T> ShouPayRespVO<T> error(String message) {
        ShouPayRespVO<T> result = new ShouPayRespVO<>();
        result.setResultCode("40500");
        result.setErrorMessage(message);
        return result;
    }
}
