package com.elitesland.cbpl.unionpay.shoupay.domain.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2023/11/28
 */
@Data
@ApiModel("交易订单商品")
public class ShouPayGoodParamVO {

    @ApiModelProperty("商品的编号")
    private String goodsId;

    @ApiModelProperty("商品名称")
    private String goodsName;

    @ApiModelProperty("商品数量")
    private Long quantity;

    /**
     * 单位为分，如2000
     */
    @ApiModelProperty("交易总金额")
    private Long price;

    /**
     * 0表示没有优惠，1表示支付机构优惠，为1会把相关信息送到支付机构
     */
    @ApiModelProperty("优惠类型")
    private int promotionType;
}
