package com.elitesland.cbpl.unionpay.shoupay.domain.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * <strong>注意事项：</strong>
 * <li>sn与client_sn不能同时为空，优先按照sn查找订单</li>
 * <li>如果没有，再按照client_sn查询</li>
 *
 * @author eric.hao
 * @since 2023/11/28
 */
@Data
@ApiModel("退款")
public class ShouPayRefundParamVO {

    @NotBlank(message = "收钱吧终端号不能为空")
    @Size(max = 32, message = "收钱吧终端号不能超过32位")
    @ApiModelProperty("收钱吧终端号")
    private String terminalSn;

    /**
     * 收钱吧系统内部唯一订单号 "7892259488292938"
     */
    @Size(max = 16, message = "收钱吧订单号不能超过16位")
    @ApiModelProperty("收钱吧唯一订单号")
    private String sn;

    /**
     * 必须在商户系统内唯一
     */
    @Size(max = 32, message = "平台订单号不能超过32位")
    @ApiModelProperty("商户系统订单号")
    private String clientSn;

    /**
     * 商户退款所需序列号，用于唯一标识某次退款请求，以防止意外的重复退款。
     * 正常情况下，对同一笔订单进行多次退款请求时该字段不能重复；
     * 而当通信质量不佳，终端不确认退款请求是否成功，自动或手动发起的退款请求重试，则务必要保持序列号不变	"23030349"
     */
    @NotBlank(message = "退款序列号不能为空")
    @ApiModelProperty("退款序列号")
    private String refundRequestNo;

    @NotBlank(message = "门店操作员不能为空")
    @ApiModelProperty("门店操作员")
    private String operator;

    @NotBlank(message = "退款金额不能为空")
    @ApiModelProperty("退款金额")
    private String refundAmount;

    /**
     * 收钱吧与特定第三方单独约定的参数集合,json格式，最多支持24个字段
     * 每个字段key长度不超过64字节，value长度不超过256字节	{ "goods_tag": "beijing"}
     */
    @ApiModelProperty("扩展参数集合")
    private Object extended;

    @ApiModelProperty("商品详情")
    private List<ShouPayGoodParamVO> goodsDetails;

    /**
     * 任何调用者希望原样返回的信息，可以用于关联商户ERP系统的订单或记录附加订单内容
     * <li>json字符串, "{ \"tips\": \"200\" }"</li>
     */
    @ApiModelProperty("反射参数")
    private Object reflect;
}
