package com.elitesland.cbpl.unionpay.shoupay.domain.param;

import cn.hutool.system.SystemUtil;
import com.elitesland.cbpl.unionpay.shoupay.cache.ShouPayDeviceVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2023/11/28
 */
@Data
@ApiModel("终端终端")
public class ShouPayTerminalParamVO {

    @ApiModelProperty(value = "终端号")
    private String terminalSn;

    @ApiModelProperty(value = "应用编号")
    private String appId;

    @ApiModelProperty(value = "激活码")
    private String code;

    @ApiModelProperty(value = "收银终端序列号")
    private String deviceId;

    @ApiModelProperty(value = "收银终端编号")
    private String clientSn;

    @ApiModelProperty(value = "收银终端名称")
    private String name;

    @ApiModelProperty(value = "当前系统信息")
    private String osInfo;

    @ApiModelProperty(value = "SDK版本")
    private String sdkVersion;

    public static ShouPayTerminalParamVO checkin(ShouPayDeviceVO device) {
        ShouPayTerminalParamVO paramVO = new ShouPayTerminalParamVO();
        paramVO.setDeviceId(device.getDeviceId());
        paramVO.setOsInfo(SystemUtil.getOsInfo().getName());
        paramVO.setSdkVersion(device.getSdkVersion());
        return paramVO;
    }
}
