/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unionpay.shoupay.common.util;

import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.unionpay.shoupay.common.util.MD5Util;
import com.elitesland.cbpl.unionpay.shoupay.domain.base.ShouPayRespVO;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static String httpPostWithoutException(String url, String string, String sign, String sn) {
        String xmlRes = "{}";
        try {
            xmlRes = HttpUtil.httpPost(url, string, sign, sn);
        }
        catch (UnrecoverableKeyException e) {
            log.error("", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("", (Throwable)e);
        }
        catch (KeyStoreException e) {
            log.error("", (Throwable)e);
        }
        catch (KeyManagementException e) {
            log.error("", (Throwable)e);
        }
        return xmlRes;
    }

    public static <T> ShouPayRespVO<T> httpPost(String url, Map<String, Object> params, String key, String sn, Class<T> clazz) {
        try {
            String sign = MD5Util.getSign(BeanUtils.toJsonStr(params) + key);
            String result = HttpUtil.httpPost(url, BeanUtils.toJsonStr(params), sign, sn);
            return (ShouPayRespVO)BeanUtils.toBean((String)result, (TypeReference)new TypeReference<ShouPayRespVO<T>>(){});
        }
        catch (Exception e) {
            log.error("[PHOENIX-UNIONPAY][SHOUPAY-ERROR] http request error:{}.", (Object)ExceptionUtils.formatException((Throwable)e));
            return ShouPayRespVO.error(ExceptionUtils.formatException((Throwable)e, (int)256));
        }
    }

    public static String httpPost(String url, String body, String sign, String sn) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        long now = System.currentTimeMillis();
        String xmlRes = "{}";
        CloseableHttpClient client = HttpUtil.createSSLClientDefault();
        HttpPost httpost = new HttpPost(url);
        try {
            log.info("[SHOUPAY-REQ][{}] URL({}), SIGN({}), SN({}).", new Object[]{now, url, sign, sn});
            log.info("[SHOUPAY-REQ][{}] Request string: {}", (Object)now, (Object)body);
            StringEntity entity = new StringEntity(body, "UTF-8");
            entity.setContentType("application/json");
            httpost.setEntity((HttpEntity)entity);
            httpost.addHeader("Content-Type", "application/json");
            httpost.addHeader("Authorization", sn + " " + sign);
            HttpResponse response = client.execute((HttpUriRequest)httpost);
            xmlRes = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            log.info("[SHOUPAY-REQ][{}] Response string: {}", (Object)now, (Object)xmlRes);
        }
        catch (ClientProtocolException e) {
            log.error("[SHOUPAY-REQ][{}] ", (Object)now, (Object)e);
        }
        catch (IOException e) {
            log.error("[SHOUPAY-REQ][{}] ", (Object)now, (Object)e);
        }
        return xmlRes;
    }

    public static CloseableHttpClient createSSLClientDefault() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        }
        catch (KeyManagementException e) {
            log.error("", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("", (Throwable)e);
        }
        catch (KeyStoreException e) {
            log.error("", (Throwable)e);
        }
        return HttpClients.createDefault();
    }

    public static String doGet(String url, String parameter) {
        String uriAPI = url + "?" + parameter;
        String result = "";
        CloseableHttpClient client = HttpUtil.createSSLClientDefault();
        HttpGet httpRequst = new HttpGet(uriAPI);
        try {
            HttpResponse httpResponse = client.execute((HttpUriRequest)httpRequst);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = httpResponse.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                result.replaceAll("\r", "");
            } else {
                httpRequst.abort();
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            result = e.getMessage().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            result = e.getMessage().toString();
        }
        return result;
    }

    public static Map<String, Object> paramToMap(Object param) {
        return BeanUtils.beanToMap((Object)param, (boolean)true, (boolean)true);
    }
}

