/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unionpay.shoupay.data.service.impl;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.unionpay.shoupay.cache.ShouPayCache;
import com.elitesland.cbpl.unionpay.shoupay.cache.ShouPayDeviceVO;
import com.elitesland.cbpl.unionpay.shoupay.config.ShouPayProperties;
import com.elitesland.cbpl.unionpay.shoupay.data.convert.ShouPayDeviceConvert;
import com.elitesland.cbpl.unionpay.shoupay.data.entity.ShouPayDeviceDO;
import com.elitesland.cbpl.unionpay.shoupay.data.repo.ShouPayDeviceRepo;
import com.elitesland.cbpl.unionpay.shoupay.data.repo.ShouPayDeviceRepoProc;
import com.elitesland.cbpl.unionpay.shoupay.data.service.ShouPayDeviceService;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayDeviceQueryParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.param.ShouPayDeviceSaveParamVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceDetailVO;
import com.elitesland.cbpl.unionpay.shoupay.data.vo.resp.ShouPayDeviceRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.base.ShouPayRespVO;
import com.elitesland.cbpl.unionpay.shoupay.domain.resp.ShouPayTerminalRespVO;
import com.elitesland.cbpl.unionpay.shoupay.proxy.ShouPayProxy;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShouPayDeviceServiceImpl
implements ShouPayDeviceService {
    private static final Logger logger = LoggerFactory.getLogger(ShouPayDeviceServiceImpl.class);
    private final ShouPayDeviceRepo shouPayDeviceRepo;
    private final ShouPayDeviceRepoProc shouPayDeviceRepoProc;
    @Autowired(required=false)
    private ShouPayProxy shouPayProxy;
    @Autowired(required=false)
    private ShouPayCache shouPayCache;

    @Override
    public List<ShouPayDeviceRespVO> shouPayDeviceByParam(ShouPayDeviceQueryParamVO query) {
        return this.shouPayDeviceRepoProc.shouPayDeviceByParam(query);
    }

    @Override
    public ShouPayDeviceDetailVO shouPayDeviceById(String deviceId) {
        Optional<ShouPayDeviceDO> shouPayDeviceDO = this.shouPayDeviceRepo.findByDeviceId(deviceId);
        if (!shouPayDeviceDO.isPresent()) {
            throw new RuntimeException("Not Found Data");
        }
        return ShouPayDeviceConvert.INSTANCE.doToVO(shouPayDeviceDO.get());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ShouPayDeviceSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            ShouPayDeviceDO shouPayDeviceDO = ShouPayDeviceConvert.INSTANCE.saveParamToDO(saveParam);
            this.shouPayDeviceRepo.save(shouPayDeviceDO);
            return shouPayDeviceDO.getId();
        }
        Optional shouPayDeviceDO = this.shouPayDeviceRepo.findById(saveParam.getId());
        if (!shouPayDeviceDO.isPresent()) {
            throw new RuntimeException("Not Found Data");
        }
        ShouPayDeviceDO shouPayDevice = (ShouPayDeviceDO)shouPayDeviceDO.get();
        ShouPayDeviceConvert.INSTANCE.saveParamMergeToDO(saveParam, shouPayDevice);
        this.shouPayDeviceRepo.save(shouPayDevice);
        return shouPayDevice.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ShouPayTerminalRespVO activate(String deviceId) {
        if (!ShouPayProperties.SHOU_PAY_ENABLED) {
            throw new RuntimeException("\u6536\u94b1\u5427\u914d\u7f6e\u672a\u5f00\u542f");
        }
        ShouPayDeviceVO device = this.shouPayCache.get(deviceId);
        if (StrUtil.isNotBlank((CharSequence)device.getTerminalSn())) {
            throw new RuntimeException("\u8be5\u8bbe\u5907\u5df2\u7ecf\u6fc0\u6d3b\uff0c\u4e0d\u7528\u91cd\u590d\u64cd\u4f5c");
        }
        ShouPayRespVO<ShouPayTerminalRespVO> result = this.shouPayProxy.activate(deviceId);
        if (result.fail()) {
            throw new RuntimeException("\u8be5\u8bbe\u5907\u6fc0\u6d3b\u5931\u8d25");
        }
        if (!result.getData().valid()) {
            throw new RuntimeException("\u8be5\u8bbe\u5907\u6fc0\u6d3b\u9519\u8bef");
        }
        logger.debug("[PHOENIX-UNIONPAY][SHOUPAY-DEBUG] activate result: {}", (Object)BeanUtils.toJsonStr(result));
        this.shouPayDeviceRepoProc.updateTerminal(deviceId, result.getData());
        return result.getData();
    }

    @Override
    public ShouPayTerminalRespVO checkin(String deviceId) {
        if (!ShouPayProperties.SHOU_PAY_ENABLED) {
            throw new RuntimeException("\u6536\u94b1\u5427\u914d\u7f6e\u672a\u5f00\u542f");
        }
        ShouPayRespVO<ShouPayTerminalRespVO> result = this.shouPayProxy.checkin(deviceId);
        if (result.fail()) {
            throw new RuntimeException("\u8be5\u8bbe\u5907\u7b7e\u5230\u5931\u8d25");
        }
        if (!result.getData().valid()) {
            throw new RuntimeException("\u8be5\u8bbe\u5907\u7b7e\u5230\u9519\u8bef");
        }
        logger.debug("[PHOENIX-UNIONPAY][SHOUPAY-DEBUG] checkin result: {}", (Object)BeanUtils.toJsonStr(result));
        this.shouPayDeviceRepoProc.updateTerminal(deviceId, result.getData());
        return result.getData();
    }

    public ShouPayDeviceServiceImpl(ShouPayDeviceRepo shouPayDeviceRepo, ShouPayDeviceRepoProc shouPayDeviceRepoProc) {
        this.shouPayDeviceRepo = shouPayDeviceRepo;
        this.shouPayDeviceRepoProc = shouPayDeviceRepoProc;
    }
}

