package com.elitesland.cbpl.web.picture.controller;

import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.web.picture.service.PictureService;
import com.elitesland.cbpl.web.picture.vo.param.PicturePagingParamVO;
import com.elitesland.cbpl.web.picture.vo.param.PictureSaveParamVO;
import com.elitesland.cbpl.web.picture.vo.resp.PictureRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 首页轮播
 *
 * @author eric.hao
 * @since 2024/11/05
 */
@Slf4j
@Api(tags = "首页轮播")
@RestController
@RequestMapping("/picture")
@RequiredArgsConstructor
public class PictureController {

    private final PictureService service;

    @PostMapping(value = "/findPage")
    @ApiOperation("分页查询")
    public HttpResult<PagingVO<PictureRespVO>> findPage(@RequestBody PicturePagingParamVO param) {
        return HttpResult.ok(service.findPageBy(param));
    }

    @ApiOperation("保存")
    @PostMapping("/save")
    public HttpResult<Void> save(@RequestBody PictureSaveParamVO saveVO) {
        service.save(saveVO);
        return HttpResult.ok();
    }

    @ApiOperation("删除")
    @DeleteMapping("/delete/{id}")
    public HttpResult<Void> delete(@PathVariable Long id) {
        service.delete(id);
        return HttpResult.ok();
    }

    @ApiOperation("批量删除")
    @DeleteMapping("/batchDelete")
    public HttpResult<Void> batchDelete(@RequestBody List<Long> ids) {
        service.batchDelete(ids);
        return HttpResult.ok();
    }

    @ApiOperation("根据id查询")
    @GetMapping("/get/{id}")
    public HttpResult<PictureRespVO> get(@PathVariable Long id) {
        return HttpResult.ok(service.get(id));
    }
}
