package com.elitesland.cbpl.web.picture.entity;

import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 首页轮播
 *
 * @author eric.hao
 * @since 2024/11/05
 */
@Entity
@Table(name = "sys_platform_website_picture")
@org.hibernate.annotations.Table(appliesTo = "sys_platform_website_picture", comment = "首页轮播")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class WebsitePictureDO extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 4285402378475915213L;
    @Column
    @Comment("图片名称")
    private String picName;

    @Column(length = 80)
    @Comment("缺省标题")
    private String imgAlt;

    @Column(length = 20)
    @Comment("位置 UDC[COM:PIC_POSITION]")
    private String position;

    @Column(length = 20)
    @Comment("类型")
    private String picType;

    @Column(nullable = false)
    @Comment("地址")
    private String picUrl;

    @Column(length = 20)
    @Comment("状态，是否显示")
    private String picStatus;

    @Column
    @Comment("序号")
    private Integer picSort;

    @Column(length = 20)
    @Comment("是否替代")
    private String updateFlag;

    @Column
    @Comment("跳转链接")
    private String linkUrl;

    @Column(length = 40)
    @Comment("链接类型 UDC[COM:PIC_LINK_TYPE]")
    private String linkType;

    @Column(length = 40)
    @Comment("颜色")
    private String picColor;

    @Column(length = 80)
    @Comment("背景图片名称")
    private String backPicName;

    @Column(length = 200)
    @Comment("背景图片地址")
    private String backPicAddr;

    @Column(length = 100)
    @Comment("区域")
    private String region;

    @Column
    @Comment("广告滚动起始日期")
    private LocalDateTime annBeginTime;

    @Column
    @Comment("广告滚动结束日期")
    private LocalDateTime annEndTime;

    @Column(length = 100)
    @Comment("分公司")
    private String branchCompany;

    @Column(length = 100)
    @Comment("游客默认显示状态")
    private String touristStatus;

    @Column(length = 100)
    @Comment("图片编码")
    private String picFileCode;

    @Column(length = 1000)
    @Comment("图片名称")
    private String picFileName;
}