package com.elitesland.cbpl.web.picture.repo;

import com.elitesland.cbpl.web.picture.entity.QWebsitePictureDO;
import com.elitesland.cbpl.web.picture.vo.param.PicturePagingParamVO;
import com.elitesland.cbpl.web.picture.vo.resp.PictureRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@Repository
@RequiredArgsConstructor
public class PictureRepoProc {

    private final JPAQueryFactory factory;
    private final QWebsitePictureDO pictureDO = QWebsitePictureDO.websitePictureDO;

    public long count(PicturePagingParamVO param) {
        List<Long> result = factory.select(pictureDO.id).from(pictureDO).where(where(param)).fetch();
        return result.size();
    }

    public List<PictureRespVO> findPage(PicturePagingParamVO param) {
        var query = factory.select(Projections.bean(PictureRespVO.class,
                pictureDO.id,
                pictureDO.picName,
                pictureDO.position,
                pictureDO.picSort,
                pictureDO.linkType,
                pictureDO.linkUrl,
                pictureDO.backPicAddr,
                pictureDO.backPicName,
                pictureDO.picUrl,
                pictureDO.picStatus,
                pictureDO.touristStatus,
                pictureDO.annBeginTime,
                pictureDO.annEndTime,
                pictureDO.picFileCode,
                pictureDO.picFileName
        )).from(pictureDO);
        param.setPaging(query);
        param.fillOrders(query, pictureDO);
        query.where(where(param));
        return query.fetch();
    }

    private Predicate where(PicturePagingParamVO param) {
        List<Predicate> predicates = new ArrayList<>();
        if (StringUtils.isNotBlank(param.getPicName())) {
            predicates.add(pictureDO.picName.contains(param.getPicName()));
        }
        if (StringUtils.isNotBlank(param.getPosition())) {
            predicates.add(pictureDO.position.eq(param.getPosition()));
        }
        if (StringUtils.isNotBlank(param.getPicStatus())) {
            predicates.add(pictureDO.picStatus.eq(param.getPicStatus()));
        }
        if (StringUtils.isNotBlank(param.getTouristStatus())) {
            predicates.add(pictureDO.touristStatus.eq(param.getTouristStatus()));
        }
        if (param.getCurrentTime() != null) {
            predicates.add(pictureDO.annBeginTime.loe(param.getCurrentTime()).and(pictureDO.annEndTime.goe(param.getCurrentTime())));
        }
        if (StringUtils.isNotBlank(param.getShowTimeFlag())) {
            LocalDateTime now = LocalDateTime.now();
            if ("0".equals(param.getShowTimeFlag())) {
                predicates.add(pictureDO.annBeginTime.isNotNull().and(pictureDO.annBeginTime.gt(now))
                        .or(pictureDO.annEndTime.isNotNull().and(pictureDO.annEndTime.lt(now)))
                );
            } else if ("1".equals(param.getShowTimeFlag())) {
                predicates.add(
                        (pictureDO.annBeginTime.isNull().or(pictureDO.annBeginTime.loe(now)))
                                .and(pictureDO.annEndTime.isNull().or(pictureDO.annEndTime.goe(now)))
                );
            }
        }

        if (StringUtils.isNotBlank(param.getRegion())) {
            predicates.add(pictureDO.region.eq(param.getRegion()));
        }
        if (StringUtils.isNotBlank(param.getBranchCompany())) {
            predicates.add(pictureDO.branchCompany.eq(param.getBranchCompany()));
        }
        if (param.getAnnEndTimeFrom() != null) {
            predicates.add(pictureDO.annEndTime.goe(param.getAnnEndTimeFrom()));
        }
        if (param.getAnnEndTimeTo() != null) {
            predicates.add(pictureDO.annEndTime.lt(param.getAnnEndTimeTo()));
        }
        return ExpressionUtils.allOf(predicates);
    }
}
