package com.elitesland.cbpl.web.picture.service;

import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.web.picture.vo.param.PicturePagingParamVO;
import com.elitesland.cbpl.web.picture.vo.param.PictureSaveParamVO;
import com.elitesland.cbpl.web.picture.vo.resp.PictureRespVO;

import java.util.List;

public interface PictureService {

    /**
     * 分页查询
     *
     * @param param 查询参数
     * @return 查询结果
     */
    PagingVO<PictureRespVO> findPageBy(PicturePagingParamVO param);

    /**
     * 新增或编辑
     *
     * @param saveParam 保存参数
     */
    void save(PictureSaveParamVO saveParam);

    /**
     * 删除
     */
    void delete(Long id);

    /**
     * 批量删除
     */
    void batchDelete(List<Long> ids);

    /**
     * 根据id查询
     */
    PictureRespVO get(Long id);
}
