package com.elitesland.cbpl.web.picture.service;

import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.web.picture.convert.PictureConvert;
import com.elitesland.cbpl.web.picture.entity.WebsitePictureDO;
import com.elitesland.cbpl.web.picture.repo.PictureRepo;
import com.elitesland.cbpl.web.picture.repo.PictureRepoProc;
import com.elitesland.cbpl.web.picture.vo.param.PicturePagingParamVO;
import com.elitesland.cbpl.web.picture.vo.param.PictureSaveParamVO;
import com.elitesland.cbpl.web.picture.vo.resp.PictureRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Slf4j
@Service
@RequiredArgsConstructor
public class PictureServiceImpl implements PictureService {

    private final PictureRepo repo;
    private final PictureRepoProc proc;

    @Override
    public PagingVO<PictureRespVO> findPageBy(PicturePagingParamVO param) {
        long total = proc.count(param);
        if (total > 0) {
            var list = proc.findPage(param);
            return new PagingVO<>(total, list);
        }
        return new PagingVO<>();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(PictureSaveParamVO saveVO) {
        if (saveVO.getId() == null) {
            repo.save(PictureConvert.INSTANCE.saveVOToDO(saveVO));
        } else {
            WebsitePictureDO pictureDO = repo.findById(saveVO.getId()).get();
            PictureConvert.INSTANCE.copySaveVOToDo(saveVO, pictureDO);
            repo.save(pictureDO);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(Long id) {
        repo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchDelete(List<Long> ids) {
        repo.deleteAllById(ids);
    }

    @Override
    public PictureRespVO get(Long id) {
        return PictureConvert.INSTANCE.doToRespVO(repo.findById(id).get());
    }
}
