package com.elitesland.cbpl.web.picture.vo.param;

import com.elitesland.cbpl.tool.db.PageQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 首页轮播 - 分页查询
 *
 * @author eric.hao
 * @since 2024/11/05
 */
@Data
public class PicturePagingParamVO extends PageQueryParam {

    private static final long serialVersionUID = -8835616980858234306L;

    @ApiModelProperty("图片名称")
    private String picName;

    @ApiModelProperty("位置")
    private String position;

    @ApiModelProperty("状态，是否显示 UDC[COM:TRUE_OR_FALSE]0否 1是")
    private String picStatus;

    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("分公司")
    private String branchCompany;

    @ApiModelProperty("是否在展示时间 UDC[COM:TRUE_OR_FALSE]0否 1是")
    private String showTimeFlag;

    @ApiModelProperty("到期时间开始")
    private LocalDateTime annEndTimeFrom;

    @ApiModelProperty("到期时间结束")
    private LocalDateTime annEndTimeTo;

    @ApiModelProperty("游客状态")
    private String touristStatus;

    @ApiModelProperty("当前时间")
    private LocalDateTime currentTime;
}