package com.elitesland.cbpl.web.picture.vo.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 首页轮播
 *
 * @author eric.hao
 * @since 2024/11/05
 */
@Data
public class PictureSaveParamVO implements Serializable {

    private static final long serialVersionUID = 6301002383800444019L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("图片名称")
    private String picName;

    @ApiModelProperty("缺省标题")
    private String imgAlt;

    @ApiModelProperty("位置")
    private String position;

    @ApiModelProperty("类型")
    private String picType;

    @ApiModelProperty("地址, not null")
    private String picUrl;

    @ApiModelProperty("状态")
    private String picStatus;

    @ApiModelProperty("序号")
    private Integer picSort;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否替代")
    private String updateFlag;

    @ApiModelProperty("链接类型")
    private Integer linkType;

    @ApiModelProperty("跳转链接")
    private String linkUrl;

    @ApiModelProperty("颜色")
    private String picColor;

    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("区域name")
    private String regionName;

    @ApiModelProperty("分公司")
    private String branchCompany;

    @ApiModelProperty("分公司name")
    private String branchCompanyName;

    @ApiModelProperty("广告滚动起始日期")
    private LocalDateTime annBeginTime;

    @ApiModelProperty("广告滚动结束日期")
    private LocalDateTime annEndTime;

    @ApiModelProperty("游客默认显示状态")
    private String touristStatus;

    @ApiModelProperty("linkUrlPart1")
    private String linkUrlPart1;

    @ApiModelProperty("linkUrlPart2")
    private String linkUrlPart2;

    @ApiModelProperty("linkUrlPart3")
    private String linkUrlPart3;

    @ApiModelProperty("linkUrlPart4")
    private String linkUrlPart4;

    @ApiModelProperty("linkUrlPart5")
    private String linkUrlPart5;

    @ApiModelProperty("linkUrlPart6")
    private String linkUrlPart6;

    @ApiModelProperty("图片编码")
    private String picFileCode;

    @ApiModelProperty("图片名称")
    private String picFileName;
}