package com.elitesland.cbpl.web.quick.controller;

import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.web.quick.service.SysQuickEntryService;
import com.elitesland.cbpl.web.quick.vo.resp.SysQuickEntryVO;
import com.elitesland.cbpl.web.quick.vo.save.SysQuickEntryCreateParam;
import com.elitesland.cbpl.web.quick.vo.save.SysQuickEntryUpdateParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

/**
 * 快捷入口
 *
 * @author eric.hao
 * @since 2024/11/11
 */
@Api(value = "快捷入口", tags = {"快捷入口"})
@RestController
@RequestMapping("/sys/sysQuickEntry")
@RequiredArgsConstructor
public class SysQuickEntryController {

    private final SysQuickEntryService sysQuickEntryService;

    @GetMapping("/findDataCurrent")
    @ApiOperation("根据当前用户查询快捷入口")
    public HttpResult<SysQuickEntryVO> findDataCurrent() {
        return HttpResult.ok(sysQuickEntryService.queryQuickEntry());
    }

    @PostMapping("/createOne")
    @ApiOperation("新增")
    public HttpResult<Long> createOne(@RequestBody SysQuickEntryCreateParam param) {
        return HttpResult.ok(sysQuickEntryService.create(param));
    }

    @PutMapping("/update")
    @ApiOperation("修改")
    public HttpResult<?> update(@RequestBody SysQuickEntryUpdateParam param) {
        sysQuickEntryService.update(param);
        return HttpResult.ok();
    }
}


