package com.elitesland.cbpl.web.quick.convert;

import com.elitesland.cbpl.web.quick.entity.SysQuickEntryDO;
import com.elitesland.cbpl.web.quick.vo.resp.SysQuickEntryVO;
import com.elitesland.cbpl.web.quick.vo.save.SysQuickEntryCreateParam;
import com.elitesland.cbpl.web.quick.vo.save.SysQuickEntryUpdateParam;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 快捷入口
 *
 * @author eric.hao
 * @since 2024/11/11
 */
@Mapper
public interface SysQuickEntryConvert {

    SysQuickEntryConvert INSTANCE = Mappers.getMapper(SysQuickEntryConvert.class);

    /**
     * DO => VO
     */
    SysQuickEntryVO doToVO(SysQuickEntryDO sysQuickEntryDO);

    /**
     * SaveParam => DO
     */
    SysQuickEntryDO creatParamToDo(SysQuickEntryCreateParam saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(SysQuickEntryUpdateParam saveParam, @MappingTarget SysQuickEntryDO quickEntry);
}

