package com.elitesland.cbpl.web.quick.entity;

import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 快捷入口
 *
 * @author eric.hao
 * @since 2024/11/11
 */
@Entity
@Table(name = "sys_quick_entry")
@org.hibernate.annotations.Table(appliesTo = "sys_quick_entry", comment = "快捷入口")
@Data
@Accessors(chain = true)
@ApiModel(value = "快捷入口", description = "快捷入口")
@DynamicUpdate
public class SysQuickEntryDO extends BaseEntity implements Serializable {

    @ApiModelProperty(value = "快捷入口数据：前端传递，后端直接返回")
    @Comment("快捷入口数据：前端传递，后端直接返回")
    @Column(length = 1024)
    private String quickData;
}
