package com.elitesland.cbpl.web.quick.service;

import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.web.iam.IamUserWeb;
import com.elitesland.cbpl.web.quick.convert.SysQuickEntryConvert;
import com.elitesland.cbpl.web.quick.entity.SysQuickEntryDO;
import com.elitesland.cbpl.web.quick.repo.SysQuickEntryRepo;
import com.elitesland.cbpl.web.quick.vo.resp.SysQuickEntryVO;
import com.elitesland.cbpl.web.quick.vo.save.SysQuickEntryCreateParam;
import com.elitesland.cbpl.web.quick.vo.save.SysQuickEntryUpdateParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Optional;

/**
 * 快捷入口
 *
 * @author eric.hao
 * @since 2024/11/11
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SysQuickEntryServiceImpl implements SysQuickEntryService {

    private final IamUserWeb iamUserWeb;
    private final SysQuickEntryRepo sysQuickEntryRepo;

    @Override
    public SysQuickEntryVO queryQuickEntry() {
        if (!iamUserWeb.isLogin()) {
            return new SysQuickEntryVO();
        }
        Optional<SysQuickEntryDO> queryEntry = sysQuickEntryRepo.findByCreateUserId(iamUserWeb.currentUserId());
        return queryEntry.isPresent() ? SysQuickEntryConvert.INSTANCE.doToVO(queryEntry.get()) : new SysQuickEntryVO();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long create(SysQuickEntryCreateParam saveParam) {
        SysQuickEntryDO sysQuickEntryDO = SysQuickEntryConvert.INSTANCE.creatParamToDo(saveParam);
        return sysQuickEntryRepo.save(sysQuickEntryDO).getId();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long update(SysQuickEntryUpdateParam saveParam) {
        Optional<SysQuickEntryDO> quickEntryDO = sysQuickEntryRepo.findById(saveParam.getId());
        if (quickEntryDO.isEmpty()) {
            throw PhoenixException.unexpected("Not Found Data");
        }
        SysQuickEntryDO quickEntry = quickEntryDO.get();
        SysQuickEntryConvert.INSTANCE.saveParamMergeToDO(saveParam, quickEntry);
        sysQuickEntryRepo.save(quickEntry);
        return quickEntry.getId();
    }
}


