package com.elitesland.cbpl.web.website.controller;

import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.web.website.service.WebsiteService;
import com.elitesland.cbpl.web.website.vo.WebsiteBasicVO;
import com.elitesland.cbpl.web.website.vo.WebsiteBeianVO;
import com.elitesland.cbpl.web.website.vo.WebsiteLogoVO;
import com.elitesland.cbpl.web.website.vo.WebsiteVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * @author eric.hao
 * @since 2024/11/06
 */
@Slf4j
@Api(tags = "站点信息配置")
@RestController
@RequestMapping("/web/site")
@RequiredArgsConstructor
public class WebsiteController {

    private final WebsiteService websiteService;

    @ApiOperation(value = "查询所有站点信息")
    @GetMapping(value = "/query")
    public HttpResult<WebsiteVO> query() {
        WebsiteVO websiteVO = websiteService.queryWebsite();
        return HttpResult.ok(websiteVO == null ? new WebsiteVO() : websiteVO);
    }

    @ApiOperation(value = "查询基础信息")
    @GetMapping(value = "/basic")
    public HttpResult<WebsiteBasicVO> queryBasicConfig() {
        WebsiteVO websiteVO = websiteService.queryWebsite();
        return HttpResult.ok(websiteVO == null ? new WebsiteBasicVO() : websiteVO.getBasicConfig());
    }

    @ApiOperation(value = "编辑基础信息")
    @PostMapping(value = "/basic/save")
    public HttpResult<Long> save(@RequestBody WebsiteBasicVO saveParam) {
        log.info("[Website] create/update basic, saveParam = {}", saveParam);
        return HttpResult.ok(websiteService.saveBasic(saveParam));
    }

    @ApiOperation(value = "查询LOGO信息")
    @GetMapping(value = "/logo")
    public HttpResult<WebsiteLogoVO> queryLogoConfig() {
        WebsiteVO websiteVO = websiteService.queryWebsite();
        return HttpResult.ok(websiteVO == null ? new WebsiteLogoVO() : websiteVO.getLogoConfig());
    }

    @ApiOperation(value = "编辑LOGO信息")
    @PostMapping(value = "/logo/save")
    public HttpResult<Long> save(@RequestBody WebsiteLogoVO saveParam) {
        log.info("[Website] create/update logo, saveParam = {}", saveParam);
        return HttpResult.ok(websiteService.saveLogo(saveParam));
    }

    @ApiOperation(value = "查询备案信息")
    @GetMapping(value = "/beian")
    public HttpResult<WebsiteBeianVO> queryBeianConfig() {
        WebsiteVO websiteVO = websiteService.queryWebsite();
        return HttpResult.ok(websiteVO == null ? new WebsiteBeianVO() : websiteVO.getBeianConfig());
    }

    @ApiOperation(value = "编辑备案信息")
    @PostMapping(value = "/beian/save")
    public HttpResult<Long> save(@RequestBody WebsiteBeianVO saveParam) {
        log.info("[Website] create/update beian, saveParam = {}", saveParam);
        return HttpResult.ok(websiteService.saveBeian(saveParam));
    }
}
