package com.elitesland.cbpl.web.website.convert;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import com.elitesland.cbpl.web.website.entity.WebsiteDO;
import com.elitesland.cbpl.web.website.vo.WebsiteBasicVO;
import com.elitesland.cbpl.web.website.vo.WebsiteBeianVO;
import com.elitesland.cbpl.web.website.vo.WebsiteLogoVO;
import com.elitesland.cbpl.web.website.vo.WebsiteVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2024/11/06
 */
@Mapper(config = BaseMapperConfig.class)
public interface WebsiteConvert {

    WebsiteConvert INSTANCE = Mappers.getMapper(WebsiteConvert.class);

    /**
     * DO => RespVO
     */
    @Mapping(target = "basicConfig", expression = "java(toBasicVO(websiteDO))")
    @Mapping(target = "logoConfig", expression = "java(toLogoVO(websiteDO))")
    @Mapping(target = "beianConfig", expression = "java(toBeianVO(websiteDO))")
    WebsiteVO doToVO(WebsiteDO websiteDO);

    @Named("toBasicVO")
    default WebsiteBasicVO toBasicVO(WebsiteDO websiteDO) {
        if (StrUtil.isBlank(websiteDO.getBasicConfig())) {
            return null;
        }
        return BeanUtils.toBean(websiteDO.getBasicConfig(), WebsiteBasicVO.class);
    }

    @Named("toLogoVO")
    default WebsiteLogoVO toLogoVO(WebsiteDO websiteDO) {
        if (StrUtil.isBlank(websiteDO.getLogoConfig())) {
            return null;
        }
        return BeanUtils.toBean(websiteDO.getLogoConfig(), WebsiteLogoVO.class);
    }

    @Named("toBasicVO")
    default WebsiteBeianVO toBeianVO(WebsiteDO websiteDO) {
        if (StrUtil.isBlank(websiteDO.getBeianConfig())) {
            return null;
        }
        return BeanUtils.toBean(websiteDO.getBeianConfig(), WebsiteBeianVO.class);
    }
}
