package com.elitesland.cbpl.web.website.entity;

import com.elitesland.cbpl.tool.db.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 站点信息配置
 *
 * @author eric.hao
 * @since 2024/11/06
 */
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Entity
@Table(name = "sys_platform_website")
@org.hibernate.annotations.Table(appliesTo = "sys_platform_website", comment = "站点信息配置")
@ApiModel("站点信息配置")
public class WebsiteDO extends BaseEntity implements Serializable {

	private static final long serialVersionUID = 6983213273586190992L;

	/**
	 * 基础信息(JSON字符串)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "基础信息(JSON字符串)")
	@Column(name = "basic_config", nullable = true)
	private String basicConfig;

	/**
	 * LOGO信息(JSON字符串)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "LOGO信息(JSON字符串)")
	@Column(name = "logo_config", nullable = true)
	private String logoConfig;

	/**
	 * 备案信息(JSON字符串)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "备案信息(JSON字符串)")
	@Column(name = "beian_config", nullable = true)
	private String beianConfig;

	/**
	 * 自定义字段(JSON字符串)
	 * nullable : true
	 * default  : null
	 */
	@ApiModelProperty(value = "自定义字段(JSON字符串)")
	@Column(name = "custom_fields", nullable = true)
	private String customFields;
}
