package com.elitesland.cbpl.web.website.service.impl;

import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.web.website.convert.WebsiteConvert;
import com.elitesland.cbpl.web.website.entity.WebsiteDO;
import com.elitesland.cbpl.web.website.repo.WebsiteRepo;
import com.elitesland.cbpl.web.website.repo.WebsiteRepoProc;
import com.elitesland.cbpl.web.website.service.WebsiteService;
import com.elitesland.cbpl.web.website.vo.WebsiteBasicVO;
import com.elitesland.cbpl.web.website.vo.WebsiteBeianVO;
import com.elitesland.cbpl.web.website.vo.WebsiteLogoVO;
import com.elitesland.cbpl.web.website.vo.WebsiteVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.function.Consumer;

/**
 * @author eric.hao
 * @since 2024/11/06
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class WebsiteServiceImpl implements WebsiteService {

    private final WebsiteRepo websiteRepo;
    private final WebsiteRepoProc websiteRepoProc;


    @Override
    public WebsiteVO queryWebsite() {
        return WebsiteConvert.INSTANCE.doToVO(queryWebsiteDO());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long saveBasic(WebsiteBasicVO saveParam) {
        return saveConfig((websiteDO) -> websiteDO.setBasicConfig(BeanUtils.toJsonStr(saveParam)));
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long saveLogo(WebsiteLogoVO saveParam) {
        return saveConfig((websiteDO) -> websiteDO.setLogoConfig(BeanUtils.toJsonStr(saveParam)));
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long saveBeian(WebsiteBeianVO saveParam) {
        return saveConfig((websiteDO) -> websiteDO.setBeianConfig(BeanUtils.toJsonStr(saveParam)));
    }

    /**
     * 查询站点信息
     */
    private WebsiteDO queryWebsiteDO() {
        List<WebsiteDO> websiteDO = websiteRepo.findByDeleteFlag(0);
        if (websiteDO.isEmpty()) {
            return null;
        }
        if (websiteDO.size() > 1) {
            throw PhoenixException.unexpected("More than one website found");
        }
        return websiteDO.get(0);
    }

    /**
     * 针对性保存数据
     */
    private Long saveConfig(Consumer<WebsiteDO> consumer) {
        WebsiteDO websiteDO = queryWebsiteDO();
        // 新增
        if (websiteDO == null) {
            websiteDO = new WebsiteDO();
        }
        consumer.accept(websiteDO);
        websiteRepo.save(websiteDO);
        return websiteDO.getId();
    }
}
