package com.elitesland.cbpl.web.website.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author eric.hao
 * @since 2024/11/06
 */
@Data
@ApiModel("站点备案信息")
public class WebsiteBeianVO {

    /**
     * 网站的备案号，显示在H5和PC端底部
     */
    @ApiModelProperty("备案号")
    private String icp;

    /**
     * H5和PC底部显示的ICP备案号点击跳转的链接
     */
    @ApiModelProperty("ICP备案链接")
    private String icpUrl;

    /**
     * 公安部门登记的备案信息，显示在PC底部
     */
    @ApiModelProperty("网安备案")
    private String security;

    /**
     * H5和PC底部显示的网安备案号点击跳转的链接
     */
    @ApiModelProperty("网安备案链接")
    private String securityUrl;
}
