/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.web.picture.controller;

import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.web.picture.service.PictureService;
import com.elitesland.cbpl.web.picture.vo.param.PicturePagingParamVO;
import com.elitesland.cbpl.web.picture.vo.param.PictureSaveParamVO;
import com.elitesland.cbpl.web.picture.vo.resp.PictureRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9996\u9875\u8f6e\u64ad"})
@RestController
@RequestMapping(value={"/picture"})
public class PictureController {
    private static final Logger log = LoggerFactory.getLogger(PictureController.class);
    private final PictureService service;

    @PostMapping(value={"/findPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public HttpResult<PagingVO<PictureRespVO>> findPage(@RequestBody PicturePagingParamVO param) {
        return HttpResult.ok(this.service.findPageBy(param));
    }

    @ApiOperation(value="\u4fdd\u5b58")
    @PostMapping(value={"/save"})
    public HttpResult<Void> save(@RequestBody PictureSaveParamVO saveVO) {
        this.service.save(saveVO);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/delete/{id}"})
    public HttpResult<Void> delete(@PathVariable Long id) {
        this.service.delete(id);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/batchDelete"})
    public HttpResult<Void> batchDelete(@RequestBody List<Long> ids) {
        this.service.batchDelete(ids);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2")
    @GetMapping(value={"/get/{id}"})
    public HttpResult<PictureRespVO> get(@PathVariable Long id) {
        return HttpResult.ok((Object)this.service.get(id));
    }

    public PictureController(PictureService service) {
        this.service = service;
    }
}

