/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.web.quick.service;

import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.web.iam.IamUserWeb;
import com.elitesland.cbpl.web.quick.convert.SysQuickEntryConvert;
import com.elitesland.cbpl.web.quick.entity.SysQuickEntryDO;
import com.elitesland.cbpl.web.quick.repo.SysQuickEntryRepo;
import com.elitesland.cbpl.web.quick.service.SysQuickEntryService;
import com.elitesland.cbpl.web.quick.vo.resp.SysQuickEntryVO;
import com.elitesland.cbpl.web.quick.vo.save.SysQuickEntryCreateParam;
import com.elitesland.cbpl.web.quick.vo.save.SysQuickEntryUpdateParam;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysQuickEntryServiceImpl
implements SysQuickEntryService {
    private static final Logger log = LoggerFactory.getLogger(SysQuickEntryServiceImpl.class);
    private final IamUserWeb iamUserWeb;
    private final SysQuickEntryRepo sysQuickEntryRepo;

    @Override
    public SysQuickEntryVO queryQuickEntry() {
        if (!this.iamUserWeb.isLogin()) {
            return new SysQuickEntryVO();
        }
        Optional<SysQuickEntryDO> queryEntry = this.sysQuickEntryRepo.findByCreateUserId(this.iamUserWeb.currentUserId());
        return queryEntry.isPresent() ? SysQuickEntryConvert.INSTANCE.doToVO(queryEntry.get()) : new SysQuickEntryVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long create(SysQuickEntryCreateParam saveParam) {
        SysQuickEntryDO sysQuickEntryDO = SysQuickEntryConvert.INSTANCE.creatParamToDo(saveParam);
        return ((SysQuickEntryDO)this.sysQuickEntryRepo.save(sysQuickEntryDO)).getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(SysQuickEntryUpdateParam saveParam) {
        Optional quickEntryDO = this.sysQuickEntryRepo.findById(saveParam.getId());
        if (quickEntryDO.isEmpty()) {
            throw PhoenixException.unexpected((String)"Not Found Data");
        }
        SysQuickEntryDO quickEntry = (SysQuickEntryDO)quickEntryDO.get();
        SysQuickEntryConvert.INSTANCE.saveParamMergeToDO(saveParam, quickEntry);
        this.sysQuickEntryRepo.save(quickEntry);
        return quickEntry.getId();
    }

    public SysQuickEntryServiceImpl(IamUserWeb iamUserWeb, SysQuickEntryRepo sysQuickEntryRepo) {
        this.iamUserWeb = iamUserWeb;
        this.sysQuickEntryRepo = sysQuickEntryRepo;
    }
}

