/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.web.website.service.impl;

import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.PhoenixException;
import com.elitesland.cbpl.web.website.convert.WebsiteConvert;
import com.elitesland.cbpl.web.website.entity.WebsiteDO;
import com.elitesland.cbpl.web.website.repo.WebsiteRepo;
import com.elitesland.cbpl.web.website.repo.WebsiteRepoProc;
import com.elitesland.cbpl.web.website.service.WebsiteService;
import com.elitesland.cbpl.web.website.vo.WebsiteBasicVO;
import com.elitesland.cbpl.web.website.vo.WebsiteBeianVO;
import com.elitesland.cbpl.web.website.vo.WebsiteLogoVO;
import com.elitesland.cbpl.web.website.vo.WebsiteVO;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebsiteServiceImpl
implements WebsiteService {
    private static final Logger log = LoggerFactory.getLogger(WebsiteServiceImpl.class);
    private final WebsiteRepo websiteRepo;
    private final WebsiteRepoProc websiteRepoProc;

    @Override
    public WebsiteVO queryWebsite() {
        return WebsiteConvert.INSTANCE.doToVO(this.queryWebsiteDO());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveBasic(WebsiteBasicVO saveParam) {
        return this.saveConfig(websiteDO -> websiteDO.setBasicConfig(BeanUtils.toJsonStr((Object)saveParam)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveLogo(WebsiteLogoVO saveParam) {
        return this.saveConfig(websiteDO -> websiteDO.setLogoConfig(BeanUtils.toJsonStr((Object)saveParam)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveBeian(WebsiteBeianVO saveParam) {
        return this.saveConfig(websiteDO -> websiteDO.setBeianConfig(BeanUtils.toJsonStr((Object)saveParam)));
    }

    private WebsiteDO queryWebsiteDO() {
        List<WebsiteDO> websiteDO = this.websiteRepo.findByDeleteFlag(0);
        if (websiteDO.isEmpty()) {
            return null;
        }
        if (websiteDO.size() > 1) {
            throw PhoenixException.unexpected((String)"More than one website found");
        }
        return websiteDO.get(0);
    }

    private Long saveConfig(Consumer<WebsiteDO> consumer) {
        WebsiteDO websiteDO = this.queryWebsiteDO();
        if (websiteDO == null) {
            websiteDO = new WebsiteDO();
        }
        consumer.accept(websiteDO);
        this.websiteRepo.save(websiteDO);
        return websiteDO.getId();
    }

    public WebsiteServiceImpl(WebsiteRepo websiteRepo, WebsiteRepoProc websiteRepoProc) {
        this.websiteRepo = websiteRepo;
        this.websiteRepoProc = websiteRepoProc;
    }
}

