/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.web.picture.service;

import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.web.picture.convert.PictureConvert;
import com.elitesland.cbpl.web.picture.entity.WebsitePictureDO;
import com.elitesland.cbpl.web.picture.repo.PictureRepo;
import com.elitesland.cbpl.web.picture.repo.PictureRepoProc;
import com.elitesland.cbpl.web.picture.service.PictureService;
import com.elitesland.cbpl.web.picture.vo.param.PicturePagingParamVO;
import com.elitesland.cbpl.web.picture.vo.param.PictureSaveParamVO;
import com.elitesland.cbpl.web.picture.vo.resp.PictureRespVO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PictureServiceImpl
implements PictureService {
    private static final Logger log = LoggerFactory.getLogger(PictureServiceImpl.class);
    private final PictureRepo repo;
    private final PictureRepoProc proc;

    @Override
    public PagingVO<PictureRespVO> findPageBy(PicturePagingParamVO param) {
        long total = this.proc.count(param);
        if (total > 0L) {
            List<PictureRespVO> list = this.proc.findPage(param);
            return new PagingVO(total, list);
        }
        return new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(PictureSaveParamVO saveVO) {
        if (saveVO.getId() == null) {
            this.repo.save(PictureConvert.INSTANCE.saveVOToDO(saveVO));
        } else {
            WebsitePictureDO pictureDO = (WebsitePictureDO)this.repo.findById(saveVO.getId()).get();
            PictureConvert.INSTANCE.copySaveVOToDo(saveVO, pictureDO);
            this.repo.save(pictureDO);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(Long id) {
        this.repo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(List<Long> ids) {
        this.repo.deleteAllById(ids);
    }

    @Override
    public PictureRespVO get(Long id) {
        return PictureConvert.INSTANCE.doToRespVO((WebsitePictureDO)this.repo.findById(id).get());
    }

    public PictureServiceImpl(PictureRepo repo, PictureRepoProc proc) {
        this.repo = repo;
        this.proc = proc;
    }
}

