/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.web.website.controller;

import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.web.website.service.WebsiteService;
import com.elitesland.cbpl.web.website.vo.WebsiteBasicVO;
import com.elitesland.cbpl.web.website.vo.WebsiteBeianVO;
import com.elitesland.cbpl.web.website.vo.WebsiteLogoVO;
import com.elitesland.cbpl.web.website.vo.WebsiteVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ad9\u70b9\u4fe1\u606f\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/web/site"})
public class WebsiteController {
    private static final Logger log = LoggerFactory.getLogger(WebsiteController.class);
    private final WebsiteService websiteService;

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7ad9\u70b9\u4fe1\u606f")
    @GetMapping(value={"/query"})
    public HttpResult<WebsiteVO> query() {
        WebsiteVO websiteVO = this.websiteService.queryWebsite();
        return HttpResult.ok((Object)(websiteVO == null ? new WebsiteVO() : websiteVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u57fa\u7840\u4fe1\u606f")
    @GetMapping(value={"/basic"})
    public HttpResult<WebsiteBasicVO> queryBasicConfig() {
        WebsiteVO websiteVO = this.websiteService.queryWebsite();
        return HttpResult.ok((Object)(websiteVO == null ? new WebsiteBasicVO() : websiteVO.getBasicConfig()));
    }

    @ApiOperation(value="\u7f16\u8f91\u57fa\u7840\u4fe1\u606f")
    @PostMapping(value={"/basic/save"})
    public HttpResult<Long> save(@RequestBody WebsiteBasicVO saveParam) {
        log.info("[Website] create/update basic, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.websiteService.saveBasic(saveParam));
    }

    @ApiOperation(value="\u67e5\u8be2LOGO\u4fe1\u606f")
    @GetMapping(value={"/logo"})
    public HttpResult<WebsiteLogoVO> queryLogoConfig() {
        WebsiteVO websiteVO = this.websiteService.queryWebsite();
        return HttpResult.ok((Object)(websiteVO == null ? new WebsiteLogoVO() : websiteVO.getLogoConfig()));
    }

    @ApiOperation(value="\u7f16\u8f91LOGO\u4fe1\u606f")
    @PostMapping(value={"/logo/save"})
    public HttpResult<Long> save(@RequestBody WebsiteLogoVO saveParam) {
        log.info("[Website] create/update logo, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.websiteService.saveLogo(saveParam));
    }

    @ApiOperation(value="\u67e5\u8be2\u5907\u6848\u4fe1\u606f")
    @GetMapping(value={"/beian"})
    public HttpResult<WebsiteBeianVO> queryBeianConfig() {
        WebsiteVO websiteVO = this.websiteService.queryWebsite();
        return HttpResult.ok((Object)(websiteVO == null ? new WebsiteBeianVO() : websiteVO.getBeianConfig()));
    }

    @ApiOperation(value="\u7f16\u8f91\u5907\u6848\u4fe1\u606f")
    @PostMapping(value={"/beian/save"})
    public HttpResult<Long> save(@RequestBody WebsiteBeianVO saveParam) {
        log.info("[Website] create/update beian, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.websiteService.saveBeian(saveParam));
    }

    public WebsiteController(WebsiteService websiteService) {
        this.websiteService = websiteService;
    }
}

