/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.web.picture.repo;

import com.elitesland.cbpl.web.picture.entity.QWebsitePictureDO;
import com.elitesland.cbpl.web.picture.vo.param.PicturePagingParamVO;
import com.elitesland.cbpl.web.picture.vo.resp.PictureRespVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class PictureRepoProc {
    private final JPAQueryFactory factory;
    private final QWebsitePictureDO pictureDO = QWebsitePictureDO.websitePictureDO;

    public long count(PicturePagingParamVO param) {
        List result = ((JPAQuery)((JPAQuery)this.factory.select(this.pictureDO.id).from((EntityPath)this.pictureDO)).where(this.where(param))).fetch();
        return result.size();
    }

    public List<PictureRespVO> findPage(PicturePagingParamVO param) {
        JPAQuery query = (JPAQuery)this.factory.select((Expression)Projections.bean(PictureRespVO.class, (Expression[])new Expression[]{this.pictureDO.id, this.pictureDO.picName, this.pictureDO.position, this.pictureDO.picSort, this.pictureDO.linkType, this.pictureDO.linkUrl, this.pictureDO.backPicAddr, this.pictureDO.backPicName, this.pictureDO.picUrl, this.pictureDO.picStatus, this.pictureDO.touristStatus, this.pictureDO.annBeginTime, this.pictureDO.annEndTime, this.pictureDO.picFileCode, this.pictureDO.picFileName, this.pictureDO.picFileCode1, this.pictureDO.picFileName1})).from((EntityPath)this.pictureDO);
        param.setPaging(query);
        param.fillOrders(query, this.pictureDO);
        query.where(this.where(param));
        return query.fetch();
    }

    private Predicate where(PicturePagingParamVO param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getPicName())) {
            predicates.add(this.pictureDO.picName.contains(param.getPicName()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getPosition())) {
            predicates.add(this.pictureDO.position.eq((Object)param.getPosition()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getPicStatus())) {
            predicates.add(this.pictureDO.picStatus.eq((Object)param.getPicStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getTouristStatus())) {
            predicates.add(this.pictureDO.touristStatus.eq((Object)param.getTouristStatus()));
        }
        if (param.getCurrentTime() != null) {
            predicates.add(this.pictureDO.annBeginTime.loe((Comparable)param.getCurrentTime()).and((Predicate)this.pictureDO.annEndTime.goe((Comparable)param.getCurrentTime())));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getShowTimeFlag())) {
            LocalDateTime now = LocalDateTime.now();
            if ("0".equals(param.getShowTimeFlag())) {
                predicates.add(this.pictureDO.annBeginTime.isNotNull().and((Predicate)this.pictureDO.annBeginTime.gt((Comparable)now)).or((Predicate)this.pictureDO.annEndTime.isNotNull().and((Predicate)this.pictureDO.annEndTime.lt((Comparable)now))));
            } else if ("1".equals(param.getShowTimeFlag())) {
                predicates.add(this.pictureDO.annBeginTime.isNull().or((Predicate)this.pictureDO.annBeginTime.loe((Comparable)now)).and((Predicate)this.pictureDO.annEndTime.isNull().or((Predicate)this.pictureDO.annEndTime.goe((Comparable)now))));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getRegion())) {
            predicates.add(this.pictureDO.region.eq((Object)param.getRegion()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBranchCompany())) {
            predicates.add(this.pictureDO.branchCompany.eq((Object)param.getBranchCompany()));
        }
        if (param.getAnnEndTimeFrom() != null) {
            predicates.add(this.pictureDO.annEndTime.goe((Comparable)param.getAnnEndTimeFrom()));
        }
        if (param.getAnnEndTimeTo() != null) {
            predicates.add(this.pictureDO.annEndTime.lt((Comparable)param.getAnnEndTimeTo()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public PictureRepoProc(JPAQueryFactory factory) {
        this.factory = factory;
    }
}

