create table sys_platform_website
(
    id             bigint           not null comment '主键' primary key,
    basic_config   text             null comment '基础信息(JSON字符串)',
    logo_config    text             null comment 'LOGO信息(JSON字符串)',
    beian_config   text             null comment '备案信息(JSON字符串)',
    custom_fields  text             null comment '自定义字段(JSON字符串)',
    tenant_id      bigint DEFAULT '-1' COMMENT '租户ID',
    remark         varchar(255)     null comment '备注',
    create_user_id bigint           null comment '记录创建者ID',
    creator        varchar(255)     null comment '记录创建者',
    create_time    datetime(6)      null comment '记录创建时间',
    modify_user_id bigint           null comment '记录最后更新者ID',
    updater        varchar(255)     null comment '记录最后更新者',
    modify_time    datetime(6)      null comment '记录最后更新时间',
    delete_flag    int    default 0 null comment '删除标记'
) comment = '站点信息配置';


create table `sys_platform_website_picture`
(
    `id`             bigint                  not null comment '记录唯一id',
    `pic_name`       varchar(255)  default null comment '图片名称',
    `img_alt`        varchar(80)   default null comment '缺省标题',
    `position`       varchar(20)   default null comment '位置 udc[srm:pic_position]',
    `pic_type`       varchar(20)   default null comment '类型',
    `pic_url`        varchar(255)            not null comment '地址',
    `pic_status`     varchar(20)   default null comment '状态，是否显示',
    `pic_sort`       int           default null comment '序号',
    `update_flag`    varchar(20)   default null comment '是否替代',
    `link_url`       varchar(255)  default null comment '跳转链接',
    `link_type`      varchar(40)   default null comment '链接类型 udc[srm:pic_link_type]',
    `pic_color`      varchar(40)   default null comment '颜色',
    `back_pic_name`  varchar(80)   default null comment '背景图片名称',
    `back_pic_addr`  varchar(200)  default null comment '背景图片地址',
    `region`         varchar(100)  default null comment '区域',
    `ann_begin_time` datetime(6)   default null comment '广告滚动起始日期',
    `ann_end_time`   datetime(6)   default null comment '广告滚动结束日期',
    `branch_company` varchar(100)  default null comment '分公司',
    `tourist_status` varchar(100)  default null comment '游客默认显示状态',
    `pic_file_code`  varchar(100)  default null comment '图片编码',
    `pic_file_name`  varchar(1000) default null comment '图片名称',
    `custom_fields`  text                    null comment '自定义字段(json字符串)',
    `tenant_id`      bigint        default '-1' comment '租户id',
    `remark`         varchar(255)            null comment '备注',
    `create_user_id` bigint                  null comment '记录创建者id',
    `creator`        varchar(255)            null comment '记录创建者',
    `create_time`    datetime(6)             null comment '记录创建时间',
    `modify_user_id` bigint                  null comment '记录最后更新者id',
    `updater`        varchar(255)            null comment '记录最后更新者',
    `modify_time`    datetime(6)             null comment '记录最后更新时间',
    `delete_flag`    int           default 0 null comment '删除标记',
    PRIMARY KEY (`id`)
) COMMENT = '首页轮播';