/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.bpmn.convert.BpmnInstanceConvert;
import com.elitesland.cbpl.bpmn.entity.BpmnInstanceDO;
import com.elitesland.cbpl.bpmn.provider.JdeApprovalProvider;
import com.elitesland.cbpl.bpmn.provider.LexiconApprovalProvider;
import com.elitesland.cbpl.bpmn.provider.OaApprovalProvider;
import com.elitesland.cbpl.bpmn.provider.QdaApprovalProvider;
import com.elitesland.cbpl.bpmn.provider.RoleApprovalProvider;
import com.elitesland.cbpl.bpmn.provider.SapApprovalProvider;
import com.elitesland.cbpl.bpmn.provider.SrmApprovalProvider;
import com.elitesland.cbpl.bpmn.provider.UserApprovalProvider;
import com.elitesland.cbpl.bpmn.provider.WorkflowApprovalProvider;
import com.elitesland.cbpl.bpmn.service.BpmnCfgService;
import com.elitesland.cbpl.bpmn.service.BpmnInstanceService;
import com.elitesland.cbpl.bpmn.udc.BpmnExternal;
import com.elitesland.cbpl.bpmn.udc.BpmnInternal;
import com.elitesland.cbpl.bpmn.udc.BpmnModule;
import com.elitesland.cbpl.bpmn.vo.param.BpmnParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnInstanceRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnResultRespVO;
import com.elitesland.cbpl.iam.IamUserUtil;
import com.elitesland.cbpl.phoenix.util.PhoenixServiceFilter;
import com.elitesland.yst.common.exception.BusinessException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BpmnService {
    private static final Logger logger = LoggerFactory.getLogger(BpmnService.class);
    private final BpmnCfgService bpmnCfgService;
    private final BpmnInstanceService bpmnInstanceService;
    @Autowired
    private List<JdeApprovalProvider> jdeApprovalProviders;
    @Autowired
    private List<SapApprovalProvider> sapApprovalProviders;
    @Autowired
    private List<QdaApprovalProvider> qdaApprovalProviders;
    @Autowired
    private List<OaApprovalProvider> oaApprovalProviders;
    @Autowired
    private List<SrmApprovalProvider> srmApprovalProviders;
    @Autowired
    private List<LexiconApprovalProvider> lexiconApprovalProviders;
    @Autowired
    private List<RoleApprovalProvider> roleApprovalProviders;
    @Autowired
    private List<UserApprovalProvider> userApprovalProviders;
    @Autowired
    private List<WorkflowApprovalProvider> workflowApprovalProviders;

    public BpmnResultRespVO startProcess(BpmnModule moduleKey, Long bizKey) {
        return this.startProcess(moduleKey, String.valueOf(bizKey));
    }

    public BpmnResultRespVO startProcess(BpmnModule moduleKey, String bizKey) {
        BpmnCfgRespVO bpmnCfgRespVO = this.bpmnCfgService.bpmnCfgByModule(moduleKey.getCode());
        if (!bpmnCfgRespVO.isEnabled()) {
            logger.info("[CBPL-BPMN] {}\u7684\u6d41\u7a0b\uff0c\u65e0\u9700\u5ba1\u6279\u3002", (Object)moduleKey.getDesc());
            return new BpmnResultRespVO();
        }
        BpmnInstanceRespVO instanceVO = this.bpmnInstanceService.bpmnInstanceByModuleBizKey(moduleKey, bizKey);
        if (ObjectUtil.isNotNull((Object)instanceVO)) {
            throw new BusinessException("\u8be5\u5355\u636e\u5df2\u63d0\u4ea4\u8fc7\u5ba1\u6279\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4");
        }
        if (bpmnCfgRespVO.isExternal()) {
            return switch (bpmnCfgRespVO.fromExternal()) {
                default -> throw new IncompatibleClassChangeError();
                case BpmnExternal.JDE -> ((JdeApprovalProvider)PhoenixServiceFilter.find(this.jdeApprovalProviders)).startProcess(bpmnCfgRespVO, bizKey);
                case BpmnExternal.QDA -> ((QdaApprovalProvider)PhoenixServiceFilter.find(this.qdaApprovalProviders)).startProcess(bpmnCfgRespVO, bizKey);
                case BpmnExternal.OA -> ((OaApprovalProvider)PhoenixServiceFilter.find(this.oaApprovalProviders)).startProcess(bpmnCfgRespVO, bizKey);
                case BpmnExternal.SAP -> ((SapApprovalProvider)PhoenixServiceFilter.find(this.sapApprovalProviders)).startProcess(bpmnCfgRespVO, bizKey);
                case BpmnExternal.SRM -> ((SrmApprovalProvider)PhoenixServiceFilter.find(this.srmApprovalProviders)).startProcess(bpmnCfgRespVO, bizKey);
            };
        }
        if (bpmnCfgRespVO.isInternal()) {
            return switch (bpmnCfgRespVO.fromInternal()) {
                default -> throw new IncompatibleClassChangeError();
                case BpmnInternal.AUTO -> ((LexiconApprovalProvider)PhoenixServiceFilter.find(this.lexiconApprovalProviders)).startProcess(bpmnCfgRespVO, bizKey);
                case BpmnInternal.ASSIGN_ROLE -> ((RoleApprovalProvider)PhoenixServiceFilter.find(this.roleApprovalProviders)).startProcess(bpmnCfgRespVO, bizKey);
                case BpmnInternal.ASSIGN_USER -> ((UserApprovalProvider)PhoenixServiceFilter.find(this.userApprovalProviders)).startProcess(bpmnCfgRespVO, bizKey);
                case BpmnInternal.WORKFLOW -> ((WorkflowApprovalProvider)PhoenixServiceFilter.find(this.workflowApprovalProviders)).startProcess(bpmnCfgRespVO, bizKey);
            };
        }
        throw new BusinessException("[\u7cfb\u7edf\u914d\u7f6e] \u5ba1\u6279\u65b9\u5f0f\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5");
    }

    public BpmnInstanceRespVO queryByBpmnInstId(Long bpmnInstId) {
        BpmnInstanceDO instanceDO = this.bpmnInstanceService.bpmnInstanceById(bpmnInstId);
        return BpmnInstanceConvert.INSTANCE.doToVO(instanceDO);
    }

    public BpmnResultRespVO agree(BpmnParamVO paramVO) {
        BpmnInstanceRespVO instanceVO = this.queryByBpmnInstId(paramVO.getBpmnInstId());
        List<String> userIds = Arrays.asList(instanceVO.getUserIds().split(","));
        if (CollUtil.isEmpty(userIds) || userIds.contains(IamUserUtil.currentUserIdStr())) {
            throw new BusinessException("\u60a8\u6ca1\u6709\u6743\u9650\u5ba1\u6279\u8be5\u5355\u636e");
        }
        BpmnCfgRespVO bpmnCfgRespVO = this.bpmnCfgService.bpmnCfgByModule(instanceVO.getModuleKey());
        if (bpmnCfgRespVO.isExternal()) {
            throw new BusinessException("\u5df2\u63d0\u4ea4\u81f3" + bpmnCfgRespVO.fromExternal() + "\u7cfb\u7edf\u5ba1\u6279");
        }
        if (bpmnCfgRespVO.isInternal()) {
            return switch (bpmnCfgRespVO.fromInternal()) {
                case BpmnInternal.ASSIGN_ROLE -> ((RoleApprovalProvider)PhoenixServiceFilter.find(this.roleApprovalProviders)).agree(bpmnCfgRespVO, instanceVO);
                case BpmnInternal.ASSIGN_USER -> ((UserApprovalProvider)PhoenixServiceFilter.find(this.userApprovalProviders)).agree(bpmnCfgRespVO, instanceVO);
                default -> {
                    String errorMsg = "[\u7cfb\u7edf\u914d\u7f6e] " + bpmnCfgRespVO.fromInternal().getDesc() + "\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c";
                    throw new BusinessException(errorMsg);
                }
            };
        }
        throw new BusinessException("[\u7cfb\u7edf\u914d\u7f6e] \u5ba1\u6279\u65b9\u5f0f\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5");
    }

    public BpmnResultRespVO reject(BpmnParamVO paramVO) {
        BpmnInstanceRespVO instanceVO = this.queryByBpmnInstId(paramVO.getBpmnInstId());
        List<String> userIds = Arrays.asList(instanceVO.getUserIds().split(","));
        if (CollUtil.isEmpty(userIds) || userIds.contains(IamUserUtil.currentUserIdStr())) {
            throw new BusinessException("\u60a8\u6ca1\u6709\u6743\u9650\u5ba1\u6279\u8be5\u5355\u636e");
        }
        BpmnCfgRespVO bpmnCfgRespVO = this.bpmnCfgService.bpmnCfgByModule(instanceVO.getModuleKey());
        if (bpmnCfgRespVO.isExternal()) {
            throw new BusinessException("\u5df2\u63d0\u4ea4\u81f3" + bpmnCfgRespVO.fromExternal() + "\u7cfb\u7edf\u5ba1\u6279");
        }
        if (bpmnCfgRespVO.isInternal()) {
            return switch (bpmnCfgRespVO.fromInternal()) {
                case BpmnInternal.ASSIGN_ROLE -> ((RoleApprovalProvider)PhoenixServiceFilter.find(this.roleApprovalProviders)).reject(bpmnCfgRespVO, instanceVO);
                case BpmnInternal.ASSIGN_USER -> ((UserApprovalProvider)PhoenixServiceFilter.find(this.userApprovalProviders)).reject(bpmnCfgRespVO, instanceVO);
                default -> {
                    String errorMsg = "[\u7cfb\u7edf\u914d\u7f6e] " + bpmnCfgRespVO.fromInternal().getDesc() + "\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c";
                    throw new BusinessException(errorMsg);
                }
            };
        }
        throw new BusinessException("[\u7cfb\u7edf\u914d\u7f6e] \u5ba1\u6279\u65b9\u5f0f\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5");
    }

    public BpmnService(BpmnCfgService bpmnCfgService, BpmnInstanceService bpmnInstanceService) {
        this.bpmnCfgService = bpmnCfgService;
        this.bpmnInstanceService = bpmnInstanceService;
    }
}

