-- ----------------------------
-- Oracle Table structure for CBPL_BPMN_INSTANCE
-- ----------------------------
CREATE TABLE CBPL_BPMN_INSTANCE
(
  ID NUMBER(20, 0) NOT NULL
, MODULE_KEY NVARCHAR2(64)
, BIZ_KEY NUMBER(20, 0)
, ROLE_IDS NVARCHAR2(255)
, USER_IDS NVARCHAR2(255)
, BPMN_METHOD NVARCHAR2(255)
, BPMN_STATUS NVARCHAR2(255)
, PROC_INST_ID NVARCHAR2(255)
, TENANT_ID NUMBER(20, 0)
, REMARK NVARCHAR2(255)
, CREATE_USER_ID NUMBER(20, 0)
, CREATOR NVARCHAR2(255)
, CREATE_TIME DATE
, MODIFY_USER_ID NUMBER(20, 0)
, UPDATER NVARCHAR2(255)
, MODIFY_TIME DATE
, DELETE_FLAG NUMBER(1, 0)
, AUDIT_DATA_VERSION NUMBER(11, 0)
, SEC_BU_ID NUMBER(20, 0)
, SEC_USER_ID NUMBER(20, 0)
, SEC_OU_ID NUMBER(20, 0)

, CONSTRAINT PK_CBPL_BPMN_INSTANCE_ID PRIMARY KEY (ID)
);

COMMENT ON COLUMN CBPL_BPMN_INSTANCE.ID IS '唯一标识';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.MODULE_KEY IS '业务模块';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.BIZ_KEY IS '业务主键';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.ROLE_IDS IS '代办人角色，逗号分隔';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.USER_IDS IS '代办人，逗号分隔';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.BPMN_METHOD IS '审批方式';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.BPMN_STATUS IS '审批状态';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.PROC_INST_ID IS '流程实例ID(目前特指CloudTi-Workflow)';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.TENANT_ID IS '租户ID';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.REMARK IS '备注';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.CREATE_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.CREATOR IS '记录创建者';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.CREATE_TIME IS '记录创建时间';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.MODIFY_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.UPDATER IS '记录最后更新者';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.MODIFY_TIME IS '记录最后更新时间';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.DELETE_FLAG IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.AUDIT_DATA_VERSION IS '锁版本';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.SEC_BU_ID IS '数据归属组织id';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.SEC_USER_ID IS '数据归属雇员id';
COMMENT ON COLUMN CBPL_BPMN_INSTANCE.SEC_OU_ID IS '数据归属公司id';
COMMENT ON TABLE CBPL_BPMN_INSTANCE IS '审批实例';