-- ----------------------------
-- Oracle Table structure for CBPL_BPMN_CONFIG
-- ----------------------------
CREATE TABLE CBPL_BPMN_CONFIG
(
  ID NUMBER(20, 0) NOT NULL
, MODULE_KEY NVARCHAR2(64)
, BPMN_ENABLE NUMBER(1, 0)
, BPMN_ENV NVARCHAR2(64)
, EXTERNAL NVARCHAR2(64)
, INTERNAL NVARCHAR2(64)
, INTERNAL_BIZ_KEY NVARCHAR2(128)
, TENANT_ID NUMBER(20, 0)
, REMARK NVARCHAR2(255)
, CREATE_USER_ID NUMBER(20, 0)
, CREATOR NVARCHAR2(255)
, CREATE_TIME DATE
, MODIFY_USER_ID NUMBER(20, 0)
, UPDATER NVARCHAR2(255)
, MODIFY_TIME DATE
, DELETE_FLAG NUMBER(1, 0)
, AUDIT_DATA_VERSION NUMBER(11, 0)
, SEC_BU_ID NUMBER(20, 0)
, SEC_USER_ID NUMBER(20, 0)
, SEC_OU_ID NUMBER(20, 0)

, CONSTRAINT PK_CBPL_BPMN_CONFIG_ID PRIMARY KEY (ID)
);

COMMENT ON COLUMN CBPL_BPMN_CONFIG.ID IS '唯一标识';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.MODULE_KEY IS '业务模块';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.BPMN_ENABLE IS '是否审批(0不需要审批；1需要审批；)';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.BPMN_ENV IS '审批环境：INTERNAL当前系统；EXTERNAL外部系统；';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.EXTERNAL IS '外部系统：JDE、SAP、QDA、OA、SRM等';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.INTERNAL IS '内部系统：自动审核、指定角色、指定人员、工作流等';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.INTERNAL_BIZ_KEY IS '内部系统类型时，对应的业务主键';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.TENANT_ID IS '租户ID';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.REMARK IS '备注';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.CREATE_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.CREATOR IS '记录创建者';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.CREATE_TIME IS '记录创建时间';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.MODIFY_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.UPDATER IS '记录最后更新者';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.MODIFY_TIME IS '记录最后更新时间';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.DELETE_FLAG IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.AUDIT_DATA_VERSION IS '锁版本';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.SEC_BU_ID IS '数据归属组织id';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.SEC_USER_ID IS '数据归属雇员id';
COMMENT ON COLUMN CBPL_BPMN_CONFIG.SEC_OU_ID IS '数据归属公司id';
COMMENT ON TABLE CBPL_BPMN_CONFIG IS '审批配置';