/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.service.impl;

import com.elitesland.cbpl.bpmn.convert.BpmnCfgConvert;
import com.elitesland.cbpl.bpmn.entity.BpmnCfgDO;
import com.elitesland.cbpl.bpmn.repo.BpmnCfgRepo;
import com.elitesland.cbpl.bpmn.repo.BpmnCfgRepoProc;
import com.elitesland.cbpl.bpmn.service.BpmnCfgService;
import com.elitesland.cbpl.bpmn.vo.param.BpmnCfgPageParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgListRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BpmnCfgServiceImpl
implements BpmnCfgService {
    private static final Logger logger = LoggerFactory.getLogger(BpmnCfgServiceImpl.class);
    private final BpmnCfgRepo bpmnCfgRepo;
    private final BpmnCfgRepoProc bpmnCfgRepoProc;

    @Override
    public PagingVO<BpmnCfgListRespVO> bpmnCfgPageBy(BpmnCfgPageParamVO paramVO) {
        long count = this.bpmnCfgRepoProc.bpmnCfgCountBy(paramVO);
        if (count > 0L) {
            List<BpmnCfgListRespVO> list = this.bpmnCfgRepoProc.bpmnCfgPageBy(paramVO);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    @Override
    public BpmnCfgRespVO bpmnCfgById(long bpmnCfgId) {
        Optional bpmnCfgDO = this.bpmnCfgRepo.findById(bpmnCfgId);
        if (bpmnCfgDO.isEmpty()) {
            throw new BusinessException("[\u5ba1\u6279\u914d\u7f6e] " + bpmnCfgId + " \u4e0d\u5b58\u5728");
        }
        return BpmnCfgConvert.INSTANCE.doToVO((BpmnCfgDO)bpmnCfgDO.get());
    }

    @Override
    public BpmnCfgRespVO bpmnCfgByModule(String moduleKey) {
        Optional<BpmnCfgDO> bpmnCfgDO = this.bpmnCfgRepo.findByModuleKey(moduleKey);
        if (bpmnCfgDO.isEmpty()) {
            throw new BusinessException("[\u5ba1\u6279\u914d\u7f6e] " + moduleKey + " \u4e0d\u5b58\u5728");
        }
        return BpmnCfgConvert.INSTANCE.doToVO(bpmnCfgDO.get());
    }

    public BpmnCfgServiceImpl(BpmnCfgRepo bpmnCfgRepo, BpmnCfgRepoProc bpmnCfgRepoProc) {
        this.bpmnCfgRepo = bpmnCfgRepo;
        this.bpmnCfgRepoProc = bpmnCfgRepoProc;
    }
}

