-- ----------------------------
-- Oracle Table structure for CBPL_BPMN_COMMENT
-- ----------------------------
CREATE TABLE CBPL_BPMN_COMMENT
(
  ID NUMBER(20, 0) NOT NULL
, BPMN_INST_ID NVARCHAR2(64)
, USER_ID NUMBER(20, 0)
, TYPE NVARCHAR2(64)
, MESSAGE NVARCHAR2(255)
, TENANT_ID NUMBER(20, 0)
, REMARK NVARCHAR2(255)
, CREATE_USER_ID NUMBER(20, 0)
, CREATOR NVARCHAR2(255)
, CREATE_TIME DATE
, MODIFY_USER_ID NUMBER(20, 0)
, UPDATER NVARCHAR2(255)
, MODIFY_TIME DATE
, DELETE_FLAG NUMBER(1, 0)
, AUDIT_DATA_VERSION NUMBER(11, 0)
, SEC_BU_ID NUMBER(20, 0)
, SEC_USER_ID NUMBER(20, 0)
, SEC_OU_ID NUMBER(20, 0)

, CONSTRAINT PK_CBPL_BPMN_COMMENT_ID PRIMARY KEY (ID)
);

COMMENT ON COLUMN CBPL_BPMN_COMMENT.ID IS '唯一标识';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.BPMN_INST_ID IS '审批实例表id';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.USER_ID IS '用户id';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.TYPE IS '审批类型';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.MESSAGE IS '审批意见';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.TENANT_ID IS '租户ID';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.REMARK IS '备注';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.CREATE_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.CREATOR IS '记录创建者';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.CREATE_TIME IS '记录创建时间';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.MODIFY_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.UPDATER IS '记录最后更新者';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.MODIFY_TIME IS '记录最后更新时间';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.DELETE_FLAG IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.AUDIT_DATA_VERSION IS '锁版本';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.SEC_BU_ID IS '数据归属组织id';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.SEC_USER_ID IS '数据归属雇员id';
COMMENT ON COLUMN CBPL_BPMN_COMMENT.SEC_OU_ID IS '数据归属公司id';
COMMENT ON TABLE CBPL_BPMN_COMMENT IS '审批实例履历';