/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.service.impl;

import com.elitesland.cbpl.bpmn.convert.BpmnCfgConvert;
import com.elitesland.cbpl.bpmn.entity.BpmnCfgDO;
import com.elitesland.cbpl.bpmn.repo.BpmnCfgRepo;
import com.elitesland.cbpl.bpmn.repo.BpmnCfgRepoProc;
import com.elitesland.cbpl.bpmn.service.BpmnCfgService;
import com.elitesland.cbpl.bpmn.udc.BpmnEnable;
import com.elitesland.cbpl.bpmn.udc.BpmnEnv;
import com.elitesland.cbpl.bpmn.udc.BpmnExternal;
import com.elitesland.cbpl.bpmn.udc.BpmnInternal;
import com.elitesland.cbpl.bpmn.udc.BpmnModule;
import com.elitesland.cbpl.bpmn.vo.param.BpmnCfgPageParamVO;
import com.elitesland.cbpl.bpmn.vo.param.BpmnCfgSaveParamVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgListRespVO;
import com.elitesland.cbpl.bpmn.vo.resp.BpmnCfgRespVO;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.base.param.OrderItem;
import com.elitesland.yst.common.exception.BusinessException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BpmnCfgServiceImpl
implements BpmnCfgService {
    private static final Logger logger = LoggerFactory.getLogger(BpmnCfgServiceImpl.class);
    private final BpmnCfgRepo bpmnCfgRepo;
    private final BpmnCfgRepoProc bpmnCfgRepoProc;

    @Override
    public PagingVO<BpmnCfgListRespVO> bpmnCfgPageBy(BpmnCfgPageParamVO paramVO) {
        long count = this.bpmnCfgRepoProc.bpmnCfgCountBy(paramVO);
        if (count > 0L) {
            paramVO.setOrders(Collections.singletonList(new OrderItem("createTime", false)));
            List<BpmnCfgListRespVO> list = this.bpmnCfgRepoProc.bpmnCfgPageBy(paramVO);
            this.translateUdc(list);
            return new PagingVO(count, list);
        }
        return new PagingVO();
    }

    private void translateUdc(List<BpmnCfgListRespVO> list) {
        Map<String, List<BpmnModule>> moduleMap = Stream.of(BpmnModule.values()).collect(Collectors.groupingBy(BpmnModule::getCode));
        Map<String, List<BpmnEnv>> envMap = Stream.of(BpmnEnv.values()).collect(Collectors.groupingBy(BpmnEnv::getCode));
        Map<String, List<BpmnExternal>> externalMap = Stream.of(BpmnExternal.values()).collect(Collectors.groupingBy(BpmnExternal::getCode));
        Map<String, List<BpmnInternal>> internalMap = Stream.of(BpmnInternal.values()).collect(Collectors.groupingBy(BpmnInternal::getCode));
        Map<Integer, List<BpmnEnable>> enableMap = Stream.of(BpmnEnable.values()).collect(Collectors.groupingBy(BpmnEnable::getCode));
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(resp -> {
                resp.setModuleKeyName(StringUtils.isNotEmpty((String)resp.getModuleKey()) ? (CollectionUtils.isNotEmpty((Collection)((Collection)moduleMap.get(resp.getModuleKey()))) ? ((BpmnModule)((Object)((Object)((List)moduleMap.get(resp.getModuleKey())).get(0)))).getDesc() : "") : "");
                resp.setBpmnEnvName(StringUtils.isNotEmpty((String)resp.getBpmnEnv()) ? (CollectionUtils.isNotEmpty((Collection)((Collection)envMap.get(resp.getBpmnEnv()))) ? ((BpmnEnv)((Object)((Object)((List)envMap.get(resp.getBpmnEnv())).get(0)))).getDesc() : "") : "");
                resp.setExternalName(StringUtils.isNotEmpty((String)resp.getExternal()) ? (CollectionUtils.isNotEmpty((Collection)((Collection)externalMap.get(resp.getExternal()))) ? ((BpmnExternal)((Object)((Object)((List)externalMap.get(resp.getExternal())).get(0)))).getDesc() : "") : "");
                resp.setInternalName(StringUtils.isNotEmpty((String)resp.getInternal()) ? (CollectionUtils.isNotEmpty((Collection)((Collection)internalMap.get(resp.getInternal()))) ? ((BpmnInternal)((Object)((Object)((List)internalMap.get(resp.getInternal())).get(0)))).getDesc() : "") : "");
                resp.setBpmnEnableName(resp.getBpmnEnable() != null ? (CollectionUtils.isNotEmpty((Collection)((Collection)enableMap.get(resp.getBpmnEnable()))) ? ((BpmnEnable)((Object)((Object)((List)enableMap.get(resp.getBpmnEnable())).get(0)))).getDesc() : "") : "");
            });
        }
    }

    @Override
    public BpmnCfgRespVO bpmnCfgById(long bpmnCfgId) {
        Optional bpmnCfgDO = this.bpmnCfgRepo.findById(bpmnCfgId);
        if (bpmnCfgDO.isEmpty()) {
            throw new BusinessException("[\u5ba1\u6279\u914d\u7f6e] " + bpmnCfgId + " \u4e0d\u5b58\u5728");
        }
        return BpmnCfgConvert.INSTANCE.doToVO((BpmnCfgDO)bpmnCfgDO.get());
    }

    @Override
    public BpmnCfgRespVO bpmnCfgByModule(String moduleKey) {
        Optional<BpmnCfgDO> bpmnCfgDO = this.bpmnCfgRepo.findByModuleKey(moduleKey);
        if (bpmnCfgDO.isEmpty()) {
            throw new BusinessException("[\u5ba1\u6279\u914d\u7f6e] " + moduleKey + " \u4e0d\u5b58\u5728");
        }
        return BpmnCfgConvert.INSTANCE.doToVO(bpmnCfgDO.get());
    }

    @Override
    public Long saveBpmnCfg(BpmnCfgSaveParamVO saveParam) {
        Optional<BpmnCfgDO> optional = this.bpmnCfgRepo.findByModuleKey(saveParam.getModuleKey());
        if (saveParam.getId() == null) {
            if (optional.isPresent()) {
                throw new BusinessException("[\u5ba1\u6279\u914d\u7f6e] " + saveParam.getModuleKey() + " \u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e");
            }
            BpmnCfgDO bpmnCfgDO = BpmnCfgConvert.INSTANCE.saveParamToDo(saveParam);
            return ((BpmnCfgDO)this.bpmnCfgRepo.save(bpmnCfgDO)).getId();
        }
        Optional option = this.bpmnCfgRepo.findById(saveParam.getId());
        if (option.isEmpty()) {
            throw new BusinessException("[\u5ba1\u6279\u914d\u7f6e] " + saveParam.getId() + " \u4e0d\u5b58\u5728");
        }
        if (!saveParam.getModuleKey().equals(((BpmnCfgDO)option.get()).getModuleKey()) && optional.isPresent()) {
            throw new BusinessException("[\u5ba1\u6279\u914d\u7f6e] " + saveParam.getModuleKey() + " \u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e");
        }
        BpmnCfgDO bpmnCfgDO = BpmnCfgConvert.INSTANCE.saveParamToDo(saveParam);
        return ((BpmnCfgDO)this.bpmnCfgRepo.save(bpmnCfgDO)).getId();
    }

    @Override
    @Transactional
    public Integer deleteBpmnCfg(long id) {
        return this.bpmnCfgRepo.updateDeleteFlag(id, 1);
    }

    public BpmnCfgServiceImpl(BpmnCfgRepo bpmnCfgRepo, BpmnCfgRepoProc bpmnCfgRepoProc) {
        this.bpmnCfgRepo = bpmnCfgRepo;
        this.bpmnCfgRepoProc = bpmnCfgRepoProc;
    }
}

