/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.bpmn.util;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitesland.cbpl.bpmn.vo.param.SensitiveWordParamVO;
import com.elitesland.yst.common.util.RedisUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class SensitiveWordUtils {
    private static final String sensitiveRedisKeyPrefix = "sensitiveWord";
    private static final String defaultSensitiveRedisKeySuffix = "ALL";
    private Map<String, String> sensitiveWordMap = new HashMap<String, String>();
    public static int minMatchTYpe = 1;
    private final RedisUtils redisClient;

    public boolean isContainsSensitiveWord(SensitiveWordParamVO wordParamVO) {
        boolean flag = false;
        if (wordParamVO != null) {
            List<String> values = this.getSensitiveWordList(wordParamVO);
            if (CollectionUtils.isNotEmpty(values)) {
                this.addSensitiveWordToHashMap(values);
            }
            if (CollectionUtils.isNotEmpty(wordParamVO.getWordList())) {
                List<String> wordList = wordParamVO.getWordList();
                int matchType = wordParamVO.getMatchType() != null ? wordParamVO.getMatchType() : minMatchTYpe;
                for (int count = 0; count < wordList.size(); ++count) {
                    String txt = wordList.get(count);
                    for (int i = 0; i < txt.length(); ++i) {
                        int matchFlag = this.checkSensitiveWord(txt, i, matchType);
                        if (matchFlag <= 0) continue;
                        flag = true;
                    }
                }
            }
        }
        return flag;
    }

    private List<String> getSensitiveWordList(SensitiveWordParamVO wordParamVO) {
        Set defaultList = this.redisClient.sGet("sensitiveWord_ALL");
        if (StringUtils.isNotEmpty((CharSequence)wordParamVO.getWordType()) && !defaultSensitiveRedisKeySuffix.equals(wordParamVO.getWordType())) {
            defaultList.addAll(this.redisClient.sGet("sensitiveWord_" + wordParamVO.getWordType()));
        }
        ArrayList<String> result = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)defaultList)) {
            defaultList.forEach(word -> result.add(String.valueOf(word)));
        }
        return result;
    }

    public int checkSensitiveWord(String txt, int beginIndex, int matchType) {
        boolean flag = false;
        int matchFlag = 0;
        char word = '\u0000';
        Map nowMap = this.sensitiveWordMap;
        for (int i = beginIndex; i < txt.length() && (nowMap = (Map)((Object)nowMap.get(Character.valueOf(word = txt.charAt(i))))) != null; ++i) {
            ++matchFlag;
            if (!"1".equals(nowMap.get("isEnd"))) continue;
            flag = true;
            if (minMatchTYpe == matchType) break;
        }
        if (!flag) {
            matchFlag = 0;
        }
        return matchFlag;
    }

    public void addSensitiveWordToHashMap(List<String> sensitiveWordList) {
        this.sensitiveWordMap = new HashMap<String, String>(sensitiveWordList.size());
        String key2 = null;
        HashMap<Object, Object> nowMap = null;
        HashMap<Object, Object> newWorMap = null;
        for (String key2 : sensitiveWordList) {
            nowMap = this.sensitiveWordMap;
            for (int i = 0; i < key2.length(); ++i) {
                char keyChar = key2.charAt(i);
                String wordMap = nowMap.get(Character.valueOf(keyChar));
                if (wordMap != null) {
                    nowMap = (HashMap<Object, Object>)((Object)wordMap);
                } else {
                    newWorMap = new HashMap<Object, Object>();
                    newWorMap.put("isEnd", "0");
                    nowMap.put(Character.valueOf(keyChar), newWorMap);
                    nowMap = newWorMap;
                }
                if (i != key2.length() - 1) continue;
                nowMap.put("isEnd", "1");
            }
        }
    }

    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
            return result;
        }
        return null;
    }

    public Set<String> getSensitiveWord(SensitiveWordParamVO wordParamVO) {
        HashSet<String> sensitiveWordList = new HashSet<String>();
        List<String> wordList = wordParamVO.getWordList();
        int matchType = wordParamVO.getMatchType() != null ? wordParamVO.getMatchType() : minMatchTYpe;
        for (int count = 0; count < wordList.size(); ++count) {
            String txt = wordList.get(count);
            for (int i = 0; i < txt.length(); ++i) {
                int length = this.checkSensitiveWord(txt, i, matchType);
                if (length <= 0) continue;
                sensitiveWordList.add(txt.substring(i, i + length));
                i = i + length - 1;
            }
        }
        return sensitiveWordList;
    }

    public SensitiveWordUtils(RedisUtils redisClient) {
        this.redisClient = redisClient;
    }
}

