/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.phoenix.util;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.iam.IamUserUtil;
import com.elitesland.cbpl.phoenix.context.Customize;
import com.elitesland.cbpl.phoenix.context.Industry;
import com.elitesland.cbpl.phoenix.context.ProcContext;
import com.elitesland.cbpl.phoenix.provider.ContextProvider;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixServiceFilter {
    private static final Logger logger = LoggerFactory.getLogger(PhoenixServiceFilter.class);

    public static <T extends ContextProvider> T find(List<T> providers) {
        ContextProvider curr = providers.stream().filter(r -> r.apply(PhoenixServiceFilter.currentProcContext())).findAny().orElseThrow(RuntimeException::new);
        logger.debug("[CBPL-PHOENIX] context provider: {}", (Object)curr.getClass().getSimpleName());
        return (T)curr;
    }

    public static ProcContext currentProcContext() {
        ProcContext ctx = ProcContext.defaultCtx();
        SysTenantDTO tenant = IamUserUtil.currentTenant();
        if (ObjectUtil.isNotNull((Object)tenant)) {
            ctx.setIndustryKey(Industry.fromCode(tenant.getIndustry()));
            ctx.setCustomizeKey(Customize.fromCode(tenant.getCustomer()));
        }
        return ctx;
    }
}

