/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.phoenix.util;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.iam.IamUserUtil;
import com.elitesland.cbpl.phoenix.context.Customize;
import com.elitesland.cbpl.phoenix.context.Industry;
import com.elitesland.cbpl.phoenix.context.ProcContext;
import com.elitesland.cbpl.phoenix.provider.ContextProvider;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixServiceFilter {
    private static final Logger logger = LoggerFactory.getLogger(PhoenixServiceFilter.class);
    private static final String ERR_TENANT_CONTEXT_CONFIG = "\u627e\u4e0d\u5230\u79df\u6237\u7684\u5b9e\u65bd\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";

    public static <T extends ContextProvider> T find(List<T> providers) {
        Optional<ContextProvider> customerProvider = providers.stream().filter(r -> r.apply(PhoenixServiceFilter.currentCustomize())).findAny();
        if (customerProvider.isPresent()) {
            logger.debug("[CBPL-PHOENIX] context provider: {}", (Object)customerProvider.getClass().getSimpleName());
            return (T)customerProvider.get();
        }
        Optional<ContextProvider> industryProvider = providers.stream().filter(r -> r.apply(PhoenixServiceFilter.currentIndustry())).findAny();
        if (industryProvider.isPresent()) {
            logger.debug("[CBPL-PHOENIX] context provider: {}", (Object)industryProvider.getClass().getSimpleName());
            return (T)industryProvider.get();
        }
        ContextProvider generalProvider = providers.stream().filter(r -> r.apply(PhoenixServiceFilter.general())).findAny().orElseThrow(() -> {
            throw new BusinessException(ERR_TENANT_CONTEXT_CONFIG);
        });
        logger.debug("[CBPL-PHOENIX] context provider: {}", (Object)generalProvider.getClass().getSimpleName());
        return (T)generalProvider;
    }

    private static ProcContext general() {
        ProcContext ctx = new ProcContext();
        ctx.setIndustryKey(Industry.GENERAL);
        return ctx;
    }

    private static ProcContext currentIndustry() {
        ProcContext ctx = PhoenixServiceFilter.general();
        SysTenantDTO tenant = IamUserUtil.currentTenant();
        if (ObjectUtil.isNotNull((Object)tenant)) {
            ctx.setIndustryKey(Industry.fromCode(tenant.getIndustry()));
        }
        return ctx;
    }

    private static ProcContext currentCustomize() {
        ProcContext ctx = new ProcContext();
        ctx.setCustomizeKey(Customize.STANDARD);
        SysTenantDTO tenant = IamUserUtil.currentTenant();
        if (ObjectUtil.isNotNull((Object)tenant)) {
            ctx.setCustomizeKey(Customize.fromCode(tenant.getCustomer()));
        }
        return ctx;
    }
}

