/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.config;

import com.elitesland.cbpl.unicom.proxy.UnicomInterfaceProxyFactoryBean;
import com.elitesland.cbpl.unicom.util.ReflectionUtil;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ProxyBeanDefinitionRegister
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ProxyBeanDefinitionRegister.class);

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        Set<Class<?>> typesAnnotatedWith = ReflectionUtil.getUnicomInterface();
        for (Class<?> superClass : typesAnnotatedWith) {
            if (!superClass.isInterface()) continue;
            RootBeanDefinition beanDefinition = new RootBeanDefinition();
            beanDefinition.setBeanClass(UnicomInterfaceProxyFactoryBean.class);
            beanDefinition.getPropertyValues().addPropertyValue("unicomInterface", superClass);
            beanDefinition.setPrimary(true);
            beanDefinition.setAutowireMode(2);
            beanDefinitionRegistry.registerBeanDefinition(superClass.getSimpleName(), (BeanDefinition)beanDefinition);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyBeanDefinitionRegister)) {
            return false;
        }
        ProxyBeanDefinitionRegister other = (ProxyBeanDefinitionRegister)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProxyBeanDefinitionRegister;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "ProxyBeanDefinitionRegister()";
    }
}

