/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.util;

import com.elitesland.cbpl.unicom.context.ProcContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnicomDubboUtil {
    private static final Logger logger = LoggerFactory.getLogger(UnicomDubboUtil.class);
    public static String HEADER_TENANT_ID = "X-Tenant-Id";
    public static final String DUBBO_USER_ID = "current_user_id";
    public static final String DUBBO_TENANT_ID = "cloudt_tenant_id";
    public static final String DUBBO_INDUSTRY_CONTEXT = "cbpl_industry_context";

    public static boolean match() {
        RpcServiceContext rpcContext = RpcContext.getServiceContext();
        return rpcContext.isProviderSide() && StringUtils.isNotBlank((CharSequence)UnicomDubboUtil.getTenantId());
    }

    public static ProcContext context() {
        RpcServiceContext rpcContext = RpcContext.getServiceContext();
        ProcContext ctx = (ProcContext)rpcContext.getObjectAttachment(DUBBO_INDUSTRY_CONTEXT);
        logger.debug("[CBPL-DUBBO] ProcContext={}", (Object)ctx);
        return ctx;
    }

    private static String getTenantId() {
        RpcServiceContext rpcContext = RpcContext.getServiceContext();
        return rpcContext.getAttachment(DUBBO_TENANT_ID);
    }
}

