/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.config;

import com.elitesland.cbpl.unicom.proxy.UnicomInterfaceProxy;
import java.util.Collection;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UnicomConfig {
    private static final Logger logger = LoggerFactory.getLogger(UnicomConfig.class);

    @Bean
    public Reflections reflections() {
        logger.info("[CBPL-UNICOM] load reflections.");
        Collection urls = ClasspathHelper.forPackage((String)"com.elitesland", (ClassLoader[])new ClassLoader[0]);
        return new Reflections((org.reflections.Configuration)new ConfigurationBuilder().setUrls(urls).addScanners(new Scanner[]{Scanners.TypesAnnotated, Scanners.SubTypes}));
    }

    @Bean
    @ConditionalOnMissingBean
    public UnicomInterfaceProxy unicomInterfaceProxy(Reflections reflections) {
        logger.info("[CBPL-UNICOM] load unicom interface proxy.");
        return new UnicomInterfaceProxy(reflections);
    }
}

