-- ----------------------------
-- Oracle Table structure for CBPL_ROSEFINCH_LOG
-- ----------------------------
CREATE TABLE CBPL_ROSEFINCH_LOG
(
  ID NUMBER(20, 0) NOT NULL
, OU_ID NUMBER(20, 0)
, ORG_ID NUMBER(20, 0)
, LOG_NO NVARCHAR2(128)
, LOG_STATUS NVARCHAR2(16)
, LOG_TYPE NUMBER(20, 0)
, SUCCESS_COUNT NUMBER(20, 0)
, FAIL_COUNT NUMBER(20, 0)
, TOTAL_COUNT NUMBER(20, 0)
, END_TIME DATE
, TENANT_ID NUMBER(20, 0)
, REMARK NVARCHAR2(255)
, CREATE_USER_ID NUMBER(20, 0)
, CREATOR NVARCHAR2(255)
, CREATE_TIME DATE
, MODIFY_USER_ID NUMBER(20, 0)
, UPDATER NVARCHAR2(255)
, MODIFY_TIME DATE
, DELETE_FLAG NUMBER(1, 0)
, AUDIT_DATA_VERSION NUMBER(11, 0)
, SEC_BU_ID NUMBER(20, 0)
, SEC_USER_ID NUMBER(20, 0)
, SEC_OU_ID NUMBER(20, 0)

, CONSTRAINT PK_CBPL_ROSEFINCH_LOG_ID PRIMARY KEY (ID)
);

COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.ID IS '唯一标识';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.OU_ID IS '公司ID';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.ORG_ID IS '组织ID';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.LOG_NO IS '日志记录编码';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.LOG_STATUS IS '日志状态';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.LOG_TYPE IS '日志类型';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.SUCCESS_COUNT IS '成功记录数';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.FAIL_COUNT IS '失败记录数';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.TOTAL_COUNT IS '记录总数';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.END_TIME IS '结束时间';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.TENANT_ID IS '租户ID';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.REMARK IS '备注';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.CREATE_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.CREATOR IS '记录创建者';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.CREATE_TIME IS '记录创建时间';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.MODIFY_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.UPDATER IS '记录最后更新者';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.MODIFY_TIME IS '记录最后更新时间';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.DELETE_FLAG IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.AUDIT_DATA_VERSION IS '锁版本';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.SEC_BU_ID IS '数据归属组织id';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.SEC_USER_ID IS '数据归属雇员id';
COMMENT ON COLUMN CBPL_ROSEFINCH_LOG.SEC_OU_ID IS '数据归属公司id';
COMMENT ON TABLE CBPL_ROSEFINCH_LOG IS '批处理日志表';