package com.elitesland.cbpl.kumiho.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.time.LocalDateTime;

/**
 * @author eric.hao
 * @since 2022/10/14
 */
public abstract class KumihoBean {

    @ApiModelProperty(value = "文档主键")
    private String rowKey;

    /**
     * 文档主键
     *
     * @return 主键
     */
    public abstract String getRowKey();

    @ApiModelProperty(value = "记录时间")
    @Field(name = "@timestamp", type = FieldType.Date, format = DateFormat.date_hour_minute_second_millis)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private final LocalDateTime timestamp = LocalDateTime.now();
}
