package com.elitesland.cbpl.rosefinch.repo;

import com.elitesland.cbpl.rosefinch.entity.QRosefinchLogDO;
import com.elitesland.cbpl.rosefinch.vo.param.RosefinchPageParamVO;
import com.elitesland.cbpl.rosefinch.vo.resp.RosefinchListRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2022/06/20
 */
@Component
@RequiredArgsConstructor
public class RosefinchRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QRosefinchLogDO Q_ROSEFINCH_LOG_DO = QRosefinchLogDO.rosefinchLogDO;

    private final QBean<RosefinchListRespVO> rosefinchListVO = Projections.bean(
            RosefinchListRespVO.class,
            Q_ROSEFINCH_LOG_DO.id,
            Q_ROSEFINCH_LOG_DO.logNo,
            Q_ROSEFINCH_LOG_DO.logStatus,
            Q_ROSEFINCH_LOG_DO.logType,
            Q_ROSEFINCH_LOG_DO.successCount,
            Q_ROSEFINCH_LOG_DO.failCount,
            Q_ROSEFINCH_LOG_DO.totalCount,
            Q_ROSEFINCH_LOG_DO.createTime,
            Q_ROSEFINCH_LOG_DO.endTime
    );

    private Predicate where(RosefinchPageParamVO paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(Q_ROSEFINCH_LOG_DO.deleteFlag.eq(0));
        return ExpressionUtils.allOf(predicates);
    }

    public long rosefinchCountBy(RosefinchPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(Q_ROSEFINCH_LOG_DO.count())
                .from(Q_ROSEFINCH_LOG_DO);
        jpaQuery.where(this.where(paramVO));
        return jpaQuery.fetchCount();
    }

    public List<RosefinchListRespVO> rosefinchPageBy(RosefinchPageParamVO paramVO) {
        var jpaQuery = jpaQueryFactory.select(rosefinchListVO)
                .from(Q_ROSEFINCH_LOG_DO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, Q_ROSEFINCH_LOG_DO);
        jpaQuery.where(this.where(paramVO));
        return jpaQuery.fetch();
    }
}
