package com.elitesland.cbpl.unicom.context;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serial;
import java.io.Serializable;

/**
 * 实施方案：定制开发 > 行业通用 > 标准实施
 *
 * @author eric.hao
 * @since 2022/03/21
 */
@Data
@Accessors(chain = true)
public class ProcContext implements Serializable {

    @Serial
    private static final long serialVersionUID = -410709116887366950L;

    /**
     * 行业版本
     */
    private Industry industryKey;

    /**
     * 定制版本
     */
    private Customize customizeKey;

    /**
     * 匹配行业实施方案
     */
    public boolean match(Industry bizCtx) {
        return bizCtx.equals(industryKey);
    }

    /**
     * 匹配定制实施方案
     */
    public boolean match(Customize bizCtx) {
        return bizCtx.equals(customizeKey);
    }
}
