package com.elitesland.cbpl.rosefinch.vo.resp;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author eric.hao
 * @since 2022/06/20
 */
@Data
@ApiModel("日志结果")
public class RosefinchListRespVO implements Serializable {

    @Serial
    private static final long serialVersionUID = -285027422359184910L;

    @ApiModelProperty("日志id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("日志记录编码")
    private String logNo;

    @ApiModelProperty("日志状态")
    private String logStatus;

    @ApiModelProperty("日志类型")
    private String logType;

    @ApiModelProperty("成功记录数")
    private Integer successCount;

    @ApiModelProperty("失败记录数")
    private Integer failCount;

    @ApiModelProperty("记录总数")
    private Integer totalCount;

    @ApiModelProperty("开始时间")
    private LocalDateTime createTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("明细行日志")
    private List<RosefinchDetailRespVO> details;
}
